/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.osgi.framework.Bundle;

public final class SelectionEnabler {
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    public static final int UNKNOWN = 0;
    public static final int ONE_OR_MORE = -1;
    public static final int ANY_NUMBER = -2;
    public static final int NONE_OR_ONE = -3;
    public static final int NONE = -4;
    public static final int MULTIPLE = -5;
    private List classes = new ArrayList();
    private ActionExpression enablementExpression;
    private int mode = 0;
    private static final String JFACE_TEXT_PLUG_IN = "org.eclipse.jface.text";
    private static final String TEXT_SELECTION_CLASS = "org.eclipse.jface.text.ITextSelection";
    private static Class iTextSelectionClass = null;
    private static boolean textSelectionPossible = true;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    private static Class getTextSelectionClass() {
        if (iTextSelectionClass != null) {
            return iTextSelectionClass;
        }
        if (!textSelectionPossible) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)JFACE_TEXT_PLUG_IN);
        if (bundle == null || bundle.getState() == 1) {
            textSelectionPossible = false;
            return null;
        }
        if (bundle.getState() == 2) {
            textSelectionPossible = true;
            return null;
        }
        try {
            Class c;
            iTextSelectionClass = c = bundle.loadClass(TEXT_SELECTION_CLASS);
            return iTextSelectionClass;
        }
        catch (ClassNotFoundException e) {
            textSelectionPossible = false;
            return null;
        }
    }

    public SelectionEnabler(IConfigurationElement configElement) {
        if (configElement == null) {
            throw new IllegalArgumentException();
        }
        this.parseClasses(configElement);
    }

    public boolean isEnabledForSelection(ISelection selection) {
        if (this.mode == 0) {
            return false;
        }
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        if (selection instanceof IStructuredSelection) {
            return this.isEnabledFor((IStructuredSelection)selection);
        }
        Class tselClass = SelectionEnabler.getTextSelectionClass();
        if (tselClass != null && tselClass.isInstance(selection)) {
            try {
                Method m = tselClass.getDeclaredMethod("getLength", new Class[0]);
                Object r = m.invoke((Object)selection, new Object[0]);
                if (r instanceof Integer) {
                    return this.isEnabledFor(selection, (Integer)r);
                }
                return true;
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return this.isEnabledFor(selection);
    }

    private boolean verifySelectionCount(int count) {
        if (count > 0 && this.mode == -4) {
            return false;
        }
        if (count == 0 && this.mode == -1) {
            return false;
        }
        if (count > 1 && this.mode == -3) {
            return false;
        }
        if (count < 2 && this.mode == -5) {
            return false;
        }
        return this.mode <= 0 || count == this.mode;
    }

    private boolean isEnabledFor(ISelection sel) {
        int count;
        ISelection obj = sel;
        int n = count = sel.isEmpty() ? 0 : 1;
        if (!this.verifySelectionCount(count)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(obj);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        if (obj instanceof IAdaptable) {
            IAdaptable element = (IAdaptable)obj;
            return this.verifyElement(element);
        }
        return false;
    }

    private boolean isEnabledFor(ISelection sel, int count) {
        if (!this.verifySelectionCount(count)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(sel);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            SelectionClass sc = (SelectionClass)this.classes.get(i);
            if (!this.verifyClass(sel, sc.className)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabledFor(IStructuredSelection ssel) {
        int count = ssel.size();
        if (!this.verifySelectionCount(count)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(ssel);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        Iterator elements = ssel.iterator();
        while (elements.hasNext()) {
            Object obj = elements.next();
            if (obj instanceof IAdaptable) {
                IAdaptable element = (IAdaptable)obj;
                if (this.verifyElement(element)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void parseClasses(IConfigurationElement config) {
        String enablesFor = config.getAttribute("enablesFor");
        if (enablesFor == null) {
            enablesFor = "*";
        }
        if (enablesFor.equals("*")) {
            this.mode = -2;
        } else if (enablesFor.equals("?")) {
            this.mode = -3;
        } else if (enablesFor.equals("!")) {
            this.mode = -4;
        } else if (enablesFor.equals("+")) {
            this.mode = -1;
        } else if (enablesFor.equals("multiple") || enablesFor.equals("2+")) {
            this.mode = -5;
        } else {
            try {
                this.mode = Integer.parseInt(enablesFor);
            }
            catch (NumberFormatException e) {
                this.mode = 0;
            }
        }
        IConfigurationElement[] children = config.getChildren("enablement");
        if (children.length > 0) {
            this.enablementExpression = new ActionExpression(children[0]);
            return;
        }
        children = config.getChildren("selection");
        if (children.length > 0) {
            this.classes = new ArrayList();
            for (int i = 0; i < children.length; ++i) {
                IConfigurationElement sel = children[i];
                String cname = sel.getAttribute(ATT_CLASS);
                String name = sel.getAttribute(ATT_NAME);
                SelectionClass sclass = new SelectionClass();
                sclass.className = cname;
                sclass.nameFilter = name;
                this.classes.add(sclass);
            }
        }
    }

    private boolean verifyClass(Object element, String className) {
        Class<?> eclass;
        boolean match = false;
        for (Class<?> clazz = eclass = element.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz.getName().equals(className)) {
                match = true;
                break;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getName().equals(className)) continue;
                match = true;
                break;
            }
            if (match) break;
        }
        return match;
    }

    private boolean verifyElement(IAdaptable element) {
        if (this.classes.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            SelectionClass sc = (SelectionClass)this.classes.get(i);
            if (!this.verifyClass(element, sc.className)) continue;
            if (sc.nameFilter == null) {
                return true;
            }
            IWorkbenchAdapter de = (IWorkbenchAdapter)element.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? SelectionEnabler.class$("org.eclipse.ui.model.IWorkbenchAdapter") : class$org$eclipse$ui$model$IWorkbenchAdapter);
            if (de == null || !SelectionEnabler.verifyNameMatch(de.getLabel(element), sc.nameFilter)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyNameMatch(String name, String filter) {
        return SimpleWildcardTester.testWildcardIgnoreCase(filter, name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SelectionClass {
        public String className;
        public boolean recursive;
        public String nameFilter;
    }
}

