/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.internal.activities.ws.CategorizedActivity;

public class ActivityCategoryContentProvider
implements ITreeContentProvider {
    private IActivityManager manager;

    public void dispose() {
        this.manager = null;
    }

    private IActivity[] getCategoryActivities(ICategory category) {
        Set activityBindings = category.getCategoryActivityBindings();
        ArrayList<CategorizedActivity> categoryActivities = new ArrayList<CategorizedActivity>(activityBindings.size());
        Iterator j = activityBindings.iterator();
        while (j.hasNext()) {
            ICategoryActivityBinding binding = (ICategoryActivityBinding)j.next();
            String activityId = binding.getActivityId();
            IActivity activity = this.manager.getActivity(activityId);
            if (!activity.isDefined()) continue;
            categoryActivities.add(new CategorizedActivity(category, activity));
        }
        return categoryActivities.toArray(new IActivity[categoryActivities.size()]);
    }

    public Object[] getDuplicateCategoryActivities(CategorizedActivity categorizedActivity) {
        ArrayList<CategorizedActivity> duplicateCategorizedactivities = new ArrayList<CategorizedActivity>();
        Set categoryIds = this.manager.getDefinedCategoryIds();
        ICategory currentCategory = null;
        String currentActivityId = null;
        IActivity[] categoryActivities = null;
        String currentCategoryId = null;
        Iterator i = categoryIds.iterator();
        block0: while (i.hasNext()) {
            currentCategoryId = (String)i.next();
            if (currentCategoryId.equals(categorizedActivity.getCategory().getId())) continue;
            currentCategory = this.manager.getCategory(currentCategoryId);
            categoryActivities = this.getCategoryActivities(currentCategory);
            for (int index = 0; index < categoryActivities.length; ++index) {
                currentActivityId = categoryActivities[index].getId();
                if (!currentActivityId.equals(categorizedActivity.getActivity().getId())) continue;
                duplicateCategorizedactivities.add(new CategorizedActivity(currentCategory, this.manager.getActivity(currentActivityId)));
                continue block0;
            }
        }
        return duplicateCategorizedactivities.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IActivityManager) {
            Set categoryIds = this.manager.getDefinedCategoryIds();
            ArrayList<ICategory> categories = new ArrayList<ICategory>(categoryIds.size());
            Iterator i = categoryIds.iterator();
            while (i.hasNext()) {
                String categoryId = (String)i.next();
                ICategory category = this.manager.getCategory(categoryId);
                if (this.getCategoryActivities(category).length <= 0) continue;
                categories.add(category);
            }
            return categories.toArray();
        }
        if (parentElement instanceof ICategory) {
            return this.getCategoryActivities((ICategory)parentElement);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof CategorizedActivity) {
            return ((CategorizedActivity)element).getCategory();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IActivityManager || element instanceof ICategory;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.manager = (IActivityManager)newInput;
    }
}

