/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;

public class PluginPathFinder {
    private static String getPath(String platformHome, File file) {
        String prefix = new Path(platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(file);
            properties.load(fis);
            fis.close();
            String path = properties.getProperty("path");
            if (path != null) {
                if (!new Path(path).isAbsolute()) {
                    path = prefix + '/' + path;
                }
                if (new File(path = path + "/eclipse/plugins").exists()) {
                    return path;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    private static File[] getSites(String platformHome) {
        ArrayList<File> sites = new ArrayList<File>();
        sites.add(new File(platformHome, "plugins"));
        File[] linkFiles = new File(platformHome + '/' + "links").listFiles();
        if (linkFiles != null) {
            for (int i = 0; i < linkFiles.length; ++i) {
                String path = PluginPathFinder.getPath(platformHome, linkFiles[i]);
                if (path == null) continue;
                sites.add(new File(path));
            }
        }
        return sites.toArray(new File[sites.size()]);
    }

    public static URL[] getPluginPaths(String platformHome) {
        if (ExternalModelManager.isTargetEqualToHost(platformHome) && !PDECore.isDevLaunchMode()) {
            return ConfiguratorUtils.getCurrentPlatformConfiguration().getPluginPath();
        }
        File file = new File(platformHome, "configuration/org.eclipse.update/platform.xml");
        if (file.exists()) {
            try {
                IPlatformConfiguration config = ConfiguratorUtils.getPlatformConfiguration((URL)file.toURL());
                return PluginPathFinder.getConfiguredSites(platformHome, config);
            }
            catch (MalformedURLException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return PluginPathFinder.scanLocations(PluginPathFinder.getSites(platformHome));
    }

    private static URL[] getConfiguredSites(String platformHome, IPlatformConfiguration configuration) {
        URL[] installPlugins = PluginPathFinder.scanLocations(new File[]{new File(platformHome, "plugins")});
        URL[] extensionPlugins = PluginPathFinder.getExtensionURLs(configuration);
        URL[] all = new URL[installPlugins.length + extensionPlugins.length];
        System.arraycopy(installPlugins, 0, all, 0, installPlugins.length);
        System.arraycopy(extensionPlugins, 0, all, installPlugins.length, extensionPlugins.length);
        return all;
    }

    private static URL[] getExtensionURLs(IPlatformConfiguration config) {
        ArrayList<URL> extensionPlugins = new ArrayList<URL>();
        IPlatformConfiguration.ISiteEntry[] sites = config.getConfiguredSites();
        for (int i = 0; i < sites.length; ++i) {
            URL url = sites[i].getURL();
            if (!"file".equalsIgnoreCase(url.getProtocol())) continue;
            String[] plugins = sites[i].getPlugins();
            for (int j = 0; j < plugins.length; ++j) {
                try {
                    extensionPlugins.add(new File(url.getFile(), plugins[j]).toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return extensionPlugins.toArray(new URL[extensionPlugins.size()]);
    }

    public static URL[] scanLocations(File[] sites) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (int i = 0; i < sites.length; ++i) {
            File[] children;
            if (!sites[i].exists() || (children = sites[i].listFiles()) == null) continue;
            for (int j = 0; j < children.length; ++j) {
                try {
                    result.add(children[j].toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }
}

