/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocation;

public class SourceLocationManager
implements ICoreConstants {
    private ArrayList fUserLocations = new ArrayList();
    private ArrayList fExtensionLocations = new ArrayList();

    public ArrayList getUserLocationArray() {
        this.initializeUserLocations();
        return this.fUserLocations;
    }

    public SourceLocation[] getUserLocations() {
        this.initializeUserLocations();
        return this.getLocations(this.fUserLocations);
    }

    public SourceLocation[] getExtensionLocations() {
        this.initializeExtensionLocations();
        return this.getLocations(this.fExtensionLocations);
    }

    private SourceLocation[] getLocations(ArrayList list) {
        return list.toArray(new SourceLocation[list.size()]);
    }

    public File findSourceFile(IPluginBase pluginBase, IPath sourcePath) {
        IStatus status = PluginVersionIdentifier.validateVersion((String)pluginBase.getVersion());
        if (status.getSeverity() != 0) {
            return null;
        }
        IPath relativePath = this.getRelativePath(pluginBase, sourcePath);
        SearchResult result = this.findSourceLocation(pluginBase, relativePath);
        return result != null ? result.file : null;
    }

    public IPath findPath(IPluginBase pluginBase, IPath sourcePath) {
        IStatus status = PluginVersionIdentifier.validateVersion((String)pluginBase.getVersion());
        if (status.getSeverity() != 0) {
            return null;
        }
        IPath relativePath = this.getRelativePath(pluginBase, sourcePath);
        SearchResult result = this.findSourceLocation(pluginBase, relativePath);
        return result == null ? null : result.loc.getPath().append(relativePath);
    }

    private IPath getRelativePath(IPluginBase pluginBase, IPath sourcePath) {
        PluginVersionIdentifier vid = new PluginVersionIdentifier(pluginBase.getVersion());
        String pluginDir = pluginBase.getId() + "_" + vid.toString();
        Path locationRelativePath = new Path(pluginDir);
        return locationRelativePath.append(sourcePath);
    }

    public SearchResult findSourceLocation(IPluginBase pluginBase, IPath relativePath) {
        this.initialize();
        SearchResult result = this.findSourceFile(this.fExtensionLocations, relativePath);
        return result != null ? result : this.findSourceFile(this.fUserLocations, relativePath);
    }

    private SearchResult findSourceFile(ArrayList list, IPath sourcePath) {
        for (int i = 0; i < list.size(); ++i) {
            SearchResult result;
            SourceLocation location = (SourceLocation)list.get(i);
            if (!location.isEnabled() || (result = this.findSourcePath(location, sourcePath)) == null) continue;
            return result;
        }
        return null;
    }

    private SearchResult findSourcePath(SourceLocation location, IPath sourcePath) {
        IPath locationPath = location.getPath();
        IPath fullPath = locationPath.append(sourcePath);
        File file = fullPath.toFile();
        return file.exists() ? new SearchResult(location, file) : null;
    }

    private void initialize() {
        this.initializeUserLocations();
        this.initializeExtensionLocations();
    }

    private void initializeUserLocations() {
        this.fUserLocations.clear();
        String pref = PDECore.getDefault().getPluginPreferences().getString("source_locations");
        if (pref.length() > 0) {
            this.parseSavedSourceLocations(pref, this.fUserLocations);
        }
    }

    private SourceLocation parseSourceLocation(String text) {
        String path;
        boolean enabled;
        try {
            text = text.trim();
            int commaIndex = text.lastIndexOf(44);
            enabled = text.charAt(commaIndex + 1) == 't';
            int atLoc = text.indexOf(64);
            path = atLoc == -1 ? text.substring(0, commaIndex) : text.substring(atLoc + 1, commaIndex);
        }
        catch (RuntimeException e) {
            return null;
        }
        return new SourceLocation((IPath)new Path(path), enabled);
    }

    private void initializeExtensionLocations() {
        int i;
        this.fExtensionLocations.clear();
        String pref = PDECore.getDefault().getPluginPreferences().getString("ext_locations");
        SourceLocation[] storedLocations = this.getSavedSourceLocations(pref);
        ModelEntry[] entries = PDECore.getDefault().getModelManager().getEntries();
        for (i = 0; i < entries.length; ++i) {
            this.processExtensions(entries[i], false);
        }
        for (i = 0; i < this.fExtensionLocations.size(); ++i) {
            SourceLocation location = (SourceLocation)this.fExtensionLocations.get(i);
            location.setEnabled(this.getSavedState(location.getPath(), storedLocations));
        }
    }

    private boolean getSavedState(IPath path, SourceLocation[] list) {
        for (int i = 0; i < list.length; ++i) {
            SourceLocation saved = list[i];
            if (!path.equals(saved.getPath())) continue;
            return saved.isEnabled();
        }
        return true;
    }

    private void parseSavedSourceLocations(String text, ArrayList entries) {
        text = text.replace(File.pathSeparatorChar, ';');
        StringTokenizer stok = new StringTokenizer(text, ";");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            SourceLocation location = this.parseSourceLocation(token);
            if (location == null) continue;
            entries.add(location);
        }
    }

    private SourceLocation[] getSavedSourceLocations(String text) {
        if (text == null || text.length() == 0) {
            return new SourceLocation[0];
        }
        ArrayList entries = new ArrayList();
        this.parseSavedSourceLocations(text, entries);
        return entries.toArray(new SourceLocation[entries.size()]);
    }

    private void processExtensions(ModelEntry entry, boolean useExternal) {
        IPluginModelBase model;
        IPluginModelBase iPluginModelBase = model = useExternal ? entry.getExternalModel() : entry.getActiveModel();
        if (model == null) {
            return;
        }
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        for (int j = 0; j < extensions.length; ++j) {
            IPluginExtension extension = extensions[j];
            String point = extension.getPoint();
            if (point == null || !point.equals(PDECore.getPluginId() + ".source")) continue;
            int origLength = this.fExtensionLocations.size();
            this.processExtension(extension);
            if (this.fExtensionLocations.size() != origLength || model.getUnderlyingResource() == null) continue;
            this.processExtensions(entry, true);
        }
    }

    private void processExtension(IPluginExtension extension) {
        IPluginObject[] children = extension.getChildren();
        for (int j = 0; j < children.length; ++j) {
            if (!children[j].getName().equals("location")) continue;
            IPluginElement element = (IPluginElement)children[j];
            String pathValue = element.getAttribute("path").getValue();
            IResource resource = extension.getModel().getUnderlyingResource();
            IPath path = resource != null && resource.isLinked() ? resource.getLocation().removeLastSegments(1).append(pathValue) : new Path(extension.getModel().getInstallLocation()).append(pathValue);
            if (!path.toFile().exists()) continue;
            SourceLocation location = new SourceLocation(path, true);
            location.setUserDefined(false);
            if (this.fExtensionLocations.contains(location)) continue;
            this.fExtensionLocations.add(location);
        }
    }

    class SearchResult {
        SourceLocation loc;
        File file;

        SearchResult(SourceLocation loc, File file) {
            this.loc = loc;
            this.file = file;
        }
    }
}

