/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroURLParser;
import org.eclipse.ui.internal.intro.impl.model.viewer.IntroModelContentProvider;
import org.eclipse.ui.internal.intro.impl.model.viewer.IntroModelLabelProvider;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;

public abstract class AbstractIntroPartImplementation {
    private CustomizableIntroPart introPart = null;
    private IMemento memento;
    private Vector history = new Vector();
    private int navigationLocation = 0;
    protected Action backAction = new Action(){
        {
            this.setToolTipText(IntroPlugin.getString("Browser.backwardButton_tooltip"));
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/backward_nav.gif"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/backward_nav.gif"));
        }

        public void run() {
            AbstractIntroPartImplementation.this.navigateBackward();
        }
    };
    protected Action forwardAction = new Action(){
        {
            this.setToolTipText(IntroPlugin.getString("Browser.forwardButton_tooltip"));
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/forward_nav.gif"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/forward_nav.gif"));
        }

        public void run() {
            AbstractIntroPartImplementation.this.navigateForward();
        }
    };
    protected Action homeAction = new Action(){
        {
            this.setToolTipText(IntroPlugin.getString("Browser.homeButton_tooltip"));
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/home_nav.gif"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/home_nav.gif"));
        }

        public void run() {
            AbstractIntroPartImplementation.this.navigateHome();
        }
    };
    protected Action viewIntroModelAction = new Action(){
        {
            this.setToolTipText(IntroPlugin.getString("IntroPart.showContentButton_tooltip"));
            this.setImageDescriptor(ImageUtil.createImageDescriptor("contents_view.gif"));
        }

        public void run() {
            ElementTreeSelectionDialog treeViewer = new ElementTreeSelectionDialog(AbstractIntroPartImplementation.this.getIntroPart().getIntroSite().getShell(), (ILabelProvider)new IntroModelLabelProvider(), (ITreeContentProvider)new IntroModelContentProvider());
            treeViewer.setInput((Object)AbstractIntroPartImplementation.this.getModel());
            treeViewer.open();
        }
    };

    public abstract void createPartControl(Composite var1);

    public void init(IIntroPart introPart, IMemento memento) throws PartInitException {
        this.introPart = (CustomizableIntroPart)introPart;
        this.memento = memento;
    }

    public IntroModelRoot getModel() {
        return IntroPlugin.getDefault().getIntroModelRoot();
    }

    public CustomizableIntroPart getIntroPart() {
        return this.introPart;
    }

    public void updateHistory(String location) {
        if (!this.history.isEmpty() && this.getCurrentLocation().equals(location)) {
            return;
        }
        this.doUpdateHistory(location);
        this.updateNavigationActionsState();
    }

    private void doUpdateHistory(String location) {
        if (this.navigationLocation == this.getHistoryEndPosition()) {
            this.pushToHistory(location);
        } else {
            this.trimHistory(location);
        }
    }

    private void pushToHistory(String location) {
        this.history.add(location);
        this.navigationLocation = this.getHistoryEndPosition();
    }

    private void trimHistory(String location) {
        List newHistory = this.history.subList(0, this.navigationLocation + 1);
        this.history = new Vector(newHistory);
        this.history.add(location);
        this.navigationLocation = this.getHistoryEndPosition();
    }

    private int getHistoryEndPosition() {
        if (this.history.isEmpty()) {
            return 0;
        }
        return this.history.size() - 1;
    }

    protected void navigateHistoryBackward() {
        if (this.badNavigationLocation(this.navigationLocation - 1)) {
            return;
        }
        --this.navigationLocation;
    }

    protected void navigateHistoryForward() {
        if (this.badNavigationLocation(this.navigationLocation + 1)) {
            return;
        }
        ++this.navigationLocation;
    }

    private boolean badNavigationLocation(int navigationLocation) {
        return navigationLocation < 0 | navigationLocation >= this.history.size();
    }

    public abstract void setFocus();

    protected abstract void updateNavigationActionsState();

    public abstract boolean navigateBackward();

    public abstract boolean navigateForward();

    public abstract boolean navigateHome();

    public void dispose() {
    }

    public String getCurrentLocation() {
        return (String)this.history.elementAt(this.navigationLocation);
    }

    public boolean canNavigateForward() {
        return this.navigationLocation != this.getHistoryEndPosition();
    }

    public boolean canNavigateBackward() {
        return this.navigationLocation != 0;
    }

    protected void addToolBarActions() {
        IActionBars actionBars = this.getIntroPart().getIntroSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)this.viewIntroModelAction);
        toolBarManager.update(true);
        actionBars.updateActionBars();
    }

    public void standbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
    }

    public void saveState(IMemento memento) {
        this.saveCurrentPage(memento);
    }

    protected void saveCurrentPage(IMemento memento) {
        IntroModelRoot model = this.getModel();
        if (memento == null || model == null) {
            return;
        }
        String currentPage = model.getCurrentPageId();
        if (currentPage != null && currentPage.length() > 0) {
            memento.putString("currentPage", currentPage);
        }
    }

    protected String getCachedCurrentPage() {
        IMemento memento = this.getMemento();
        if (memento == null) {
            return null;
        }
        return memento.getString("currentPage");
    }

    protected boolean isURL(String aString) {
        IntroURLParser parser = new IntroURLParser(aString);
        return parser.hasProtocol();
    }

    public IMemento getMemento() {
        return this.memento;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        this.history.clear();
        this.navigationLocation = 0;
        this.handleRegistryChanged(event);
    }

    protected abstract void handleRegistryChanged(IRegistryChangeEvent var1);
}

