/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FilteredServiceListener;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext,
EventDispatcher {
    private boolean valid;
    protected BundleHost bundle;
    protected Framework framework;
    protected Hashtable servicesInUse;
    protected EventListeners bundleEvent;
    protected EventListeners bundleEventSync;
    protected EventListeners serviceEvent;
    protected EventListeners frameworkEvent;
    protected BundleActivator activator;
    protected Object contextLock = new Object();

    protected BundleContextImpl(BundleHost bundle) {
        this.bundle = bundle;
        this.valid = true;
        this.framework = bundle.framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.serviceEvent = null;
        this.frameworkEvent = null;
        this.servicesInUse = null;
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        if (this.serviceEvent != null) {
            this.framework.serviceEvent.removeListener(this);
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.framework.frameworkEvent.removeListener(this);
            this.frameworkEvent = null;
        }
        if (this.bundleEvent != null) {
            this.framework.bundleEvent.removeListener(this);
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.framework.bundleEventSync.removeListener(this);
            this.bundleEventSync = null;
        }
        ServiceReference[] publishedReferences = null;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            publishedReferences = this.framework.serviceRegistry.lookupServiceReferences(this);
        }
        if (publishedReferences != null) {
            for (int i = 0; i < publishedReferences.length; ++i) {
                try {
                    ((ServiceReferenceImpl)publishedReferences[i]).registration.unregister();
                    continue;
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
        }
        if (this.servicesInUse != null) {
            int usedSize;
            ServiceReference[] usedRefs = null;
            Hashtable hashtable = this.servicesInUse;
            synchronized (hashtable) {
                usedSize = this.servicesInUse.size();
                if (usedSize > 0) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("Releasing services");
                    }
                    usedRefs = new ServiceReference[usedSize];
                    Enumeration enumeration = this.servicesInUse.keys();
                    for (int i = 0; i < usedSize; ++i) {
                        usedRefs[i] = (ServiceReference)enumeration.nextElement();
                    }
                }
            }
            for (int i = 0; i < usedSize; ++i) {
                ((ServiceReferenceImpl)usedRefs[i]).registration.releaseService(this);
            }
            this.servicesInUse = null;
        }
        this.bundle = null;
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return this.framework.getProperty(key);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.bundle;
    }

    public Bundle installBundle(String location) throws BundleException {
        this.framework.checkAdminPermission();
        this.checkValid();
        return this.framework.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream in) throws BundleException {
        this.framework.checkAdminPermission();
        this.checkValid();
        return this.framework.installBundle(location, in);
    }

    public Bundle getBundle(long id) {
        return this.framework.getBundle(id);
    }

    public AbstractBundle getBundleByLocation(String location) {
        return this.framework.getBundleByLocation(location);
    }

    public Bundle[] getBundles() {
        return this.framework.getAllBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("addServiceListener[" + this.bundle + "](" + listenerName + ", \"" + filter + "\")");
        }
        ServiceListener filteredListener = filter == null ? listener : new FilteredServiceListener(filter, listener);
        EventListeners eventListeners = this.framework.serviceEvent;
        synchronized (eventListeners) {
            if (this.serviceEvent == null) {
                this.serviceEvent = new EventListeners();
                this.framework.serviceEvent.addListener(this, this);
            }
            this.serviceEvent.addListener(listener, filteredListener);
        }
    }

    public void addServiceListener(ServiceListener listener) {
        block2: {
            try {
                this.addServiceListener(listener, null);
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("removeServiceListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (this.serviceEvent != null) {
            EventListeners eventListeners = this.framework.serviceEvent;
            synchronized (eventListeners) {
                this.serviceEvent.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener listener) {
        EventListeners eventListeners;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("addBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission();
            eventListeners = this.framework.bundleEventSync;
            synchronized (eventListeners) {
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new EventListeners();
                    this.framework.bundleEventSync.addListener(this, this);
                }
                this.bundleEventSync.addListener(listener, listener);
            }
        }
        eventListeners = this.framework.bundleEvent;
        synchronized (eventListeners) {
            if (this.bundleEvent == null) {
                this.bundleEvent = new EventListeners();
                this.framework.bundleEvent.addListener(this, this);
            }
            this.bundleEvent.addListener(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener listener) {
        EventListeners eventListeners;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("removeBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission();
            if (this.bundleEventSync != null) {
                eventListeners = this.framework.bundleEventSync;
                synchronized (eventListeners) {
                    this.bundleEventSync.removeListener(listener);
                }
            }
        } else if (this.bundleEvent != null) {
            eventListeners = this.framework.bundleEvent;
            synchronized (eventListeners) {
                this.bundleEvent.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("addFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        EventListeners eventListeners = this.framework.frameworkEvent;
        synchronized (eventListeners) {
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new EventListeners();
                this.framework.frameworkEvent.addListener(this, this);
            }
            this.frameworkEvent.addListener(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (this.frameworkEvent != null) {
            EventListeners eventListeners = this.framework.frameworkEvent;
            synchronized (eventListeners) {
                this.frameworkEvent.removeListener(listener);
            }
        }
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValid();
        if (service == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new NullPointerException(Msg.formatter.getString("SERVICE_ARGUMENT_NULL_EXCEPTION"));
        }
        int size = clazzes.length;
        if (size == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.formatter.getString("SERVICE_EMPTY_CLASS_LIST_EXCEPTION"));
        }
        String[] copy = new String[clazzes.length];
        for (int i = 0; i < clazzes.length; ++i) {
            copy[i] = new String(clazzes[i].getBytes());
        }
        clazzes = copy;
        this.framework.checkRegisterServicePermission(clazzes);
        if (!(service instanceof ServiceFactory)) {
            PackageAdminImpl packageAdmin = this.framework.packageAdmin;
            for (int i = 0; i < size; ++i) {
                Class clazz = packageAdmin.loadServiceClass(clazzes[i], this.bundle);
                if (clazz == null) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println(clazzes[i] + " class not found");
                    }
                    throw new IllegalArgumentException(Msg.formatter.getString("SERVICE_CLASS_NOT_FOUND_EXCEPTION", clazzes[i]));
                }
                if (clazz.isInstance(service)) continue;
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("Service object is not an instanceof " + clazzes[i]);
                }
                throw new IllegalArgumentException(Msg.formatter.getString("SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION", clazzes[i]));
            }
        }
        return this.createServiceRegistration(clazzes, service, properties);
    }

    protected ServiceRegistrationImpl createServiceRegistration(String[] clazzes, Object service, Dictionary properties) {
        return new ServiceRegistrationImpl(this, clazzes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        String[] clazzes = new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getServiceReferences(" + clazz + ", \"" + filter + "\")");
        }
        return this.framework.getServiceReferences(clazz, filter);
    }

    public ServiceReference getServiceReference(String clazz) {
        block9: {
            this.checkValid();
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + clazz + ")");
            }
            try {
                ServiceReference[] references = this.framework.getServiceReferences(clazz, null);
                if (references != null) {
                    int index = 0;
                    int length = references.length;
                    if (length > 1) {
                        int[] rankings = new int[length];
                        int count = 0;
                        int maxRanking = Integer.MIN_VALUE;
                        for (int i = 0; i < length; ++i) {
                            int ranking;
                            rankings[i] = ranking = ((ServiceReferenceImpl)references[i]).getRanking();
                            if (ranking > maxRanking) {
                                index = i;
                                maxRanking = ranking;
                                count = 1;
                                continue;
                            }
                            if (ranking != maxRanking) continue;
                            ++count;
                        }
                        if (count > 1) {
                            long minId = Long.MAX_VALUE;
                            for (int i = 0; i < length; ++i) {
                                long id;
                                if (rankings[i] != maxRanking || (id = ((ServiceReferenceImpl)references[i]).getId()) >= minId) continue;
                                index = i;
                                minId = id;
                            }
                        }
                    }
                    return references[index];
                }
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block9;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        this.checkValid();
        if (this.servicesInUse == null) {
            Object object = this.contextLock;
            synchronized (object) {
                if (this.servicesInUse == null) {
                    this.servicesInUse = new Hashtable(10);
                }
            }
        }
        ServiceRegistrationImpl registration = ((ServiceReferenceImpl)reference).registration;
        this.framework.checkGetServicePermission(registration.clazzes);
        return registration.getService(this);
    }

    public boolean ungetService(ServiceReference reference) {
        this.checkValid();
        ServiceRegistrationImpl registration = ((ServiceReferenceImpl)reference).registration;
        return registration.ungetService(this);
    }

    public File getDataFile(String filename) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, filename);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException be) {
                this.activator = null;
                throw be;
            }
        }
    }

    protected void startActivator(final BundleActivator bundleActivator) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (bundleActivator != null) {
                        bundleActivator.start((BundleContext)BundleContextImpl.this);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.printStackTrace(t2);
            }
            String clazz = null;
            clazz = bundleActivator.getClass().getName();
            throw new BundleException(Msg.formatter.getString("BUNDLE_ACTIVATOR_EXCEPTION", new Object[]{clazz, "start", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), (Throwable)t2);
        }
    }

    protected void stop() throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (BundleContextImpl.this.activator != null) {
                        BundleContextImpl.this.activator.stop((BundleContext)BundleContextImpl.this);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.printStackTrace(t2);
            }
            String clazz = this.activator == null ? "" : this.activator.getClass().getName();
            throw new BundleException(Msg.formatter.getString("BUNDLE_ACTIVATOR_EXCEPTION", new Object[]{clazz, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), (Throwable)t2);
        }
        finally {
            this.activator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference[] getRegisteredServices() {
        ServiceReference[] services = null;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            services = this.framework.serviceRegistry.lookupServiceReferences(this);
            if (services == null) {
                return null;
            }
            int removed = 0;
            for (int i = services.length - 1; i >= 0; --i) {
                ServiceReferenceImpl ref = (ServiceReferenceImpl)services[i];
                String[] classes = ref.getClasses();
                try {
                    this.framework.checkGetServicePermission(classes);
                    continue;
                }
                catch (SecurityException se) {
                    services[i] = null;
                    ++removed;
                }
            }
            if (removed > 0) {
                ServiceReference[] temp = services;
                services = new ServiceReference[temp.length - removed];
                for (int i = temp.length - 1; i >= 0; --i) {
                    if (temp[i] == null) {
                        --removed;
                        continue;
                    }
                    services[i - removed] = temp[i];
                }
            }
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReferenceImpl[] getServicesInUse() {
        if (this.servicesInUse == null) {
            return null;
        }
        Hashtable hashtable = this.servicesInUse;
        synchronized (hashtable) {
            int size = this.servicesInUse.size();
            if (size == 0) {
                return null;
            }
            ServiceReferenceImpl[] references = new ServiceReferenceImpl[size];
            int refcount = 0;
            Enumeration enumeration = this.servicesInUse.keys();
            for (int i = 0; i < size; ++i) {
                ServiceReferenceImpl reference = (ServiceReferenceImpl)enumeration.nextElement();
                try {
                    this.framework.checkGetServicePermission(reference.registration.clazzes);
                }
                catch (SecurityException se) {
                    continue;
                }
                references[refcount] = reference;
                ++refcount;
            }
            if (refcount < size) {
                if (refcount == 0) {
                    return null;
                }
                ServiceReferenceImpl[] refs = references;
                references = new ServiceReferenceImpl[refcount];
                System.arraycopy(refs, 0, references, 0, refcount);
            }
            return references;
        }
    }

    public void dispatchEvent(Object originalListener, Object l, int action, Object object) {
        block12: {
            BundleHost tmpBundle = this.bundle;
            try {
                if (this.isValid()) {
                    switch (action) {
                        case 1: 
                        case 2: {
                            BundleListener listener = (BundleListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
                                Debug.println("dispatchBundleEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.bundleChanged((BundleEvent)object);
                            break;
                        }
                        case 3: {
                            ServiceEvent event = (ServiceEvent)object;
                            if (!this.hasListenServicePermission(event)) break;
                            ServiceListener listener = (ServiceListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
                                Debug.println("dispatchServiceEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.serviceChanged(event);
                            break;
                        }
                        case 4: {
                            FrameworkListener listener = (FrameworkListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(listener.hashCode());
                                Debug.println("dispatchFrameworkEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.frameworkEvent((FrameworkEvent)object);
                            break;
                        }
                    }
                }
            }
            catch (Throwable t) {
                FrameworkEvent event;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in bottom level event dispatcher: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                this.framework.adaptor.handleRuntimeError(t);
                if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) break block12;
                this.framework.publishFrameworkEvent(2, tmpBundle, t);
            }
        }
    }

    protected boolean hasListenServicePermission(ServiceEvent event) {
        ProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            ServiceReferenceImpl reference = (ServiceReferenceImpl)event.getServiceReference();
            String[] names = reference.registration.clazzes;
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                if (!domain.implies((Permission)new ServicePermission(names[i], "get"))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return new FilterImpl(filter);
    }

    protected void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.formatter.getString("BUNDLE_CONTEXT_INVALID_EXCEPTION"));
        }
    }

    protected boolean isValid() {
        return this.valid;
    }
}

