/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.ProvidingBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;
    protected Vector removalPending;
    protected KeyedHashSet exportedPackages;
    protected KeyedHashSet exportedBundles;
    private long cumulativeTime;
    private static boolean checkServiceClassSource = true;
    private static boolean restrictServiceClasses = false;

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    protected void initialize() {
        checkServiceClassSource = Boolean.valueOf(System.getProperty("osgi.checkServiceClassSource", "true"));
        restrictServiceClasses = Boolean.valueOf(System.getProperty("osgi.restrictServiceClasses", "false"));
        this.removalPending = new Vector(10, 10);
        State state = this.framework.adaptor.getState();
        if (!state.isResolved()) {
            state.resolve(false);
        }
        this.exportedPackages = new KeyedHashSet(false);
        this.exportedBundles = new KeyedHashSet(false);
    }

    private KeyedHashSet getExportedPackages(KeyedHashSet packageSet) {
        State state = this.framework.adaptor.getState();
        PackageSpecification[] packageSpecs = state.getExportedPackages();
        for (int i = 0; i < packageSpecs.length; ++i) {
            BundleDescription bundleSpec = packageSpecs[i].getSupplier();
            if (bundleSpec == null) continue;
            AbstractBundle bundle = this.framework.getBundle(bundleSpec.getBundleId());
            if (bundle == null) {
                BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_FRAMEWORK", bundleSpec));
                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
                continue;
            }
            if (!bundle.checkExportPackagePermission(packageSpecs[i].getName())) continue;
            HostSpecification hostSpec = bundleSpec.getHost();
            if (hostSpec != null) {
                bundleSpec = hostSpec.getSupplier();
                if (bundleSpec == null) continue;
                bundle = this.framework.getBundle(bundleSpec.getBundleId());
                if (bundle == null) {
                    BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_FRAMEWORK", bundleSpec));
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
                    continue;
                }
            }
            if (!bundle.isResolved() || !(bundle instanceof BundleHost)) continue;
            ExportedPackageImpl packagesource = new ExportedPackageImpl(packageSpecs[i], ((BundleHost)bundle).getLoaderProxy());
            packageSet.add(packagesource);
        }
        return packageSet;
    }

    private KeyedHashSet getExportedBundles(KeyedHashSet bundleSet) {
        State state = this.framework.adaptor.getState();
        BundleDescription[] bundleDescripts = state.getResolvedBundles();
        for (int i = 0; i < bundleDescripts.length; ++i) {
            BundleDescription bundledes = bundleDescripts[i];
            AbstractBundle bundle = this.framework.getBundle(bundledes.getBundleId());
            if (bundle == null || !bundle.isResolved() || bundle.getSymbolicName() == null || !(bundle instanceof BundleHost) || !bundle.checkProvideBundlePermission(bundle.getSymbolicName())) continue;
            BundleLoaderProxy loaderProxy = ((BundleHost)bundle).getLoaderProxy();
            bundleSet.add(loaderProxy);
        }
        return bundleSet;
    }

    protected void cleanup() {
        this.removalPending = null;
        this.exportedPackages = null;
        this.exportedBundles = null;
    }

    protected void addRemovalPending(BundleLoaderProxy loaderProxy) {
        this.removalPending.addElement(loaderProxy);
    }

    protected void deleteRemovalPending(BundleLoaderProxy loaderProxy) throws BundleException {
        boolean exporting = loaderProxy.inUse();
        if (exporting) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("BundleLoader.unexportPackager returned true! " + loaderProxy);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            throw new BundleException(Msg.formatter.getString("OSGI_INTERNAL_ERROR"));
        }
        this.unexportResources(loaderProxy);
        BundleLoader loader = loaderProxy.getBundleLoader();
        loader.clear();
        loader.close();
        this.removalPending.remove(loaderProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            this.framework.bundles.markDependancies();
            KeyedElement[] elements = this.exportedPackages.elements();
            if (bundle != null) {
                Vector<ExportedPackageImpl> result = new Vector<ExportedPackageImpl>();
                for (int i = 0; i < elements.length; ++i) {
                    ExportedPackageImpl pkgElement = (ExportedPackageImpl)elements[i];
                    if (pkgElement.supplier.getBundleHost() != bundle) continue;
                    result.add(pkgElement);
                }
                if (result.size() == 0) {
                    return null;
                }
                ExportedPackageImpl[] pkgElements = new ExportedPackageImpl[result.size()];
                return result.toArray(pkgElements);
            }
            if (elements.length == 0) {
                return null;
            }
            ExportedPackage[] pkgElements = new ExportedPackageImpl[elements.length];
            System.arraycopy(elements, 0, pkgElements, 0, pkgElements.length);
            return pkgElements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage getExportedPackage(String packageName) {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            this.framework.bundles.markDependancies();
            return (ExportedPackageImpl)this.exportedPackages.getByKey(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] input) {
        this.framework.checkAdminPermission();
        AbstractBundle[] copy = null;
        if (input != null) {
            Bundle[] bundleArray = input;
            // MONITORENTER : input
            int size = input.length;
            copy = new AbstractBundle[size];
            System.arraycopy(input, 0, copy, 0, size);
            // MONITOREXIT : bundleArray
        }
        final AbstractBundle[] bundles = copy;
        Thread refresh = SecureAction.createThread(new Runnable(){

            public void run() {
                PackageAdminImpl.this.refreshPackages(bundles);
            }
        }, "Refresh Packages");
        refresh.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPackages(AbstractBundle[] refresh) {
        try {
            Vector graph = null;
            BundleRepository bundleRepository = this.framework.bundles;
            synchronized (bundleRepository) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: Initialize graph");
                }
                this.framework.bundles.markDependancies();
                graph = this.computeAffectedBundles(refresh);
                State state = this.framework.adaptor.getState();
                state.resolve(false);
                this.processDelta(graph);
            }
            this.resumeBundles(graph);
        }
        finally {
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
        }
    }

    private void resumeBundles(Vector graph) {
        Object[] refresh = new AbstractBundle[graph.size()];
        boolean[] previouslyResolved = new boolean[graph.size()];
        graph.copyInto(refresh);
        Util.sort(refresh, 0, graph.size());
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: restart the bundles");
        }
        for (int i = 0; i < refresh.length; ++i) {
            Object bundle = refresh[i];
            if (!((AbstractBundle)bundle).isResolved()) continue;
            this.framework.resumeBundle((AbstractBundle)bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelta(Vector graph) {
        Object[] refresh = new AbstractBundle[graph.size()];
        boolean[] previouslyResolved = new boolean[graph.size()];
        graph.copyInto(refresh);
        Util.sort(refresh, 0, graph.size());
        Vector<AbstractBundle> notify = new Vector<AbstractBundle>();
        try {
            block27: {
                try {
                    BundleLoaderProxy loaderProxy;
                    Object changedBundle;
                    int i;
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                    }
                    for (i = refresh.length - 1; i >= 0; --i) {
                        changedBundle = refresh[i];
                        previouslyResolved[i] = ((AbstractBundle)changedBundle).isResolved();
                        if (((AbstractBundle)changedBundle).isActive() && !((AbstractBundle)changedBundle).isFragment()) {
                            boolean suspended = this.framework.suspendBundle((AbstractBundle)changedBundle, true);
                            if (!suspended) {
                                throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION"));
                            }
                        } else {
                            ((AbstractBundle)changedBundle).beginStateChange();
                        }
                        if (!Debug.DEBUG_PACKAGEADMIN || ((AbstractBundle)changedBundle).stateChanging != null) continue;
                        Debug.println("Bundle state change lock is clear! " + changedBundle);
                        Debug.printStackTrace(new Exception("Stack trace"));
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: refresh the bundles");
                    }
                    for (i = this.removalPending.size() - 1; i >= 0; --i) {
                        loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                        if (!graph.contains(loaderProxy.getBundleHost())) continue;
                        this.framework.bundles.unMarkDependancies(loaderProxy);
                    }
                    for (i = 0; i < refresh.length; ++i) {
                        changedBundle = refresh[i];
                        ((AbstractBundle)changedBundle).refresh();
                        if (!previouslyResolved[i]) continue;
                        this.framework.publishBundleEvent(64, (Bundle)changedBundle);
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: unexport the removal pending packages");
                    }
                    for (i = this.removalPending.size() - 1; i >= 0; --i) {
                        loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                        AbstractBundle removedBundle = loaderProxy.getBundleHost();
                        if (!graph.contains(removedBundle)) continue;
                        this.deleteRemovalPending(loaderProxy);
                    }
                    List allBundles = this.framework.bundles.getBundles();
                    int size = allBundles.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        BundleDescription bundleDes;
                        AbstractBundle bundle = (AbstractBundle)allBundles.get(i2);
                        if (bundle.isResolved() || (bundleDes = bundle.getBundleDescription()) == null || !bundleDes.isResolved()) continue;
                        if (bundle.isFragment()) {
                            BundleHost host = (BundleHost)this.framework.getBundle(bundleDes.getHost().getSupplier().getBundleId());
                            if (((BundleFragment)bundle).setHost(host)) {
                                bundle.resolve(bundleDes.isSingleton());
                            }
                        } else {
                            bundle.resolve(bundleDes.isSingleton());
                        }
                        if (!bundle.isResolved()) continue;
                        notify.addElement(bundle);
                    }
                    this.exportedPackages = this.getExportedPackages(this.exportedPackages);
                    this.exportedBundles = this.getExportedBundles(this.exportedBundles);
                    Object var12_19 = null;
                    if (!Debug.DEBUG_PACKAGEADMIN) break block27;
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    for (int i = 0; i < refresh.length; ++i) {
                        Object changedBundle = refresh[i];
                        ((AbstractBundle)changedBundle).completeStateChange();
                    }
                    throw throwable;
                }
                Debug.println("refreshPackages: release the state change locks");
            }
            for (int i = 0; i < refresh.length; ++i) {
                Object changedBundle = refresh[i];
                ((AbstractBundle)changedBundle).completeStateChange();
            }
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages: clean up adaptor storage");
            }
            try {
                this.framework.adaptor.compactStorage();
            }
            catch (IOException e) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages exception: " + e.getMessage());
                    Debug.printStackTrace(e);
                }
                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), (Throwable)e));
            }
        }
        catch (BundleException e) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + e.getMessage());
                Debug.printStackTrace(e.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), (Throwable)e));
        }
        for (int i = 0; i < notify.size(); ++i) {
            AbstractBundle changedBundle = (AbstractBundle)notify.elementAt(i);
            this.framework.publishBundleEvent(changedBundle.isResolved() ? 32 : 64, changedBundle);
        }
    }

    private void unresolvePermissions(Vector bundles, Hashtable packages) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: unresolve permissions");
        }
        int size = bundles.size();
        for (int i = 0; i < size; ++i) {
            AbstractBundle bundle = (AbstractBundle)bundles.elementAt(i);
            bundle.unresolvePermissions(packages);
        }
    }

    private Vector computeAffectedBundles(AbstractBundle[] refresh) {
        boolean changed;
        AbstractBundle bundle;
        Vector<Bundle> graph = new Vector<Bundle>();
        if (refresh == null) {
            int size = this.removalPending.size();
            for (int i = 0; i < size; ++i) {
                BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                bundle = loaderProxy.getBundleHost();
                if (graph.contains(bundle)) continue;
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println(" refresh: " + bundle);
                }
                graph.addElement(bundle);
                AbstractBundle[] dependents = loaderProxy.getDependentBundles();
                for (int j = 0; j < dependents.length; ++j) {
                    if (graph.contains(dependents[j])) continue;
                    graph.addElement(dependents[j]);
                }
            }
        } else {
            for (int i = 0; i < refresh.length; ++i) {
                BundleHost host;
                AbstractBundle bundle2 = refresh[i];
                if (bundle2 == this.framework.systemBundle) continue;
                if (bundle2.isFragment() && (host = (BundleHost)bundle2.getHost()) != null && !graph.contains(host)) {
                    graph.addElement(host);
                }
                if (graph.contains(bundle2)) continue;
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println(" refresh: " + bundle2);
                }
                graph.addElement(bundle2);
            }
        }
        if (graph.size() == 0) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages: Empty graph");
            }
            return graph;
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: Complete graph");
        }
        do {
            int i;
            changed = false;
            int size = graph.size();
            for (i = size - 1; i >= 0; --i) {
                AbstractBundle[] sameNames;
                bundle = (AbstractBundle)graph.elementAt(i);
                if (!bundle.isFragment()) {
                    Bundle[] frags;
                    int j;
                    BundleLoaderProxy loaderProxy = ((BundleHost)bundle).getLoaderProxy();
                    if (loaderProxy != null) {
                        AbstractBundle[] dependents = loaderProxy.getDependentBundles();
                        for (j = 0; j < dependents.length; ++j) {
                            if (graph.contains(dependents[j])) continue;
                            graph.addElement(dependents[j]);
                            changed = true;
                        }
                    }
                    if ((frags = bundle.getFragments()) != null) {
                        for (j = 0; j < frags.length; ++j) {
                            if (graph.contains(frags[j])) continue;
                            graph.addElement(frags[j]);
                            changed = true;
                        }
                    }
                } else {
                    AbstractBundle host = (AbstractBundle)bundle.getHost();
                    if (host != null && !graph.contains(host)) {
                        graph.addElement(host);
                        changed = true;
                    }
                }
                if ((sameNames = this.framework.bundles.getBundles(bundle.getSymbolicName())) == null || sameNames.length <= 1) continue;
                for (int j = 0; j < sameNames.length; ++j) {
                    if (sameNames[j] == bundle || !sameNames[j].isSingleton() || graph.contains(sameNames[j])) continue;
                    graph.addElement(sameNames[j]);
                    changed = true;
                }
            }
            for (i = this.removalPending.size() - 1; i >= 0; --i) {
                BundleLoaderProxy removedLoaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                AbstractBundle removedBundle = removedLoaderProxy.getBundleHost();
                if (!graph.contains(removedBundle)) {
                    graph.addElement(removedBundle);
                    changed = true;
                }
                AbstractBundle[] dependents = removedLoaderProxy.getDependentBundles();
                for (int k = 0; k < dependents.length; ++k) {
                    if (graph.contains(dependents[k])) continue;
                    graph.addElement(dependents[k]);
                    changed = true;
                }
            }
        } while (changed);
        return graph;
    }

    protected void setResolvedBundles() {
        State state = this.framework.adaptor.getState();
        BundleDescription[] descriptions = state.getBundles();
        for (int i = 0; i < descriptions.length; ++i) {
            long bundleId = descriptions[i].getBundleId();
            AbstractBundle bundle = this.framework.getBundle(bundleId);
            if (bundle == null) {
                BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_FRAMEWORK", descriptions[i]));
                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
            }
            if (bundle == this.framework.systemBundle || !descriptions[i].isResolved()) continue;
            if (bundle.isFragment()) {
                BundleHost host = (BundleHost)this.framework.getBundle(descriptions[i].getHost().getSupplier().getBundleId());
                if (!((BundleFragment)bundle).setHost(host)) continue;
                bundle.resolve(descriptions[i].isSingleton());
                continue;
            }
            bundle.resolve(descriptions[i].isSingleton());
        }
        this.exportedPackages = this.getExportedPackages(this.exportedPackages);
        this.exportedBundles = this.getExportedBundles(this.exportedBundles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveBundles(Bundle[] bundles) {
        this.resolveBundles();
        if (bundles == null) {
            BundleRepository bundleRepository = this.framework.bundles;
            synchronized (bundleRepository) {
                List bundleList = this.framework.bundles.getBundles();
                bundles = bundleList.toArray(new AbstractBundle[bundleList.size()]);
            }
        }
        for (int i = 0; i < bundles.length; ++i) {
            if (((AbstractBundle)bundles[i]).isResolved()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveBundles() {
        long start = 0L;
        if (Debug.DEBUG_PACKAGEADMIN_TIMING) {
            start = System.currentTimeMillis();
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshBundles: resolve bundles");
        }
        Vector<AbstractBundle> notify = new Vector<AbstractBundle>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            int i;
            boolean resolveNeeded = false;
            List allBundles = this.framework.bundles.getBundles();
            int size = allBundles.size();
            for (i = 0; i < size; ++i) {
                if (((AbstractBundle)allBundles.get(i)).isResolved()) continue;
                resolveNeeded = true;
            }
            if (!resolveNeeded) {
                return;
            }
            this.framework.adaptor.getState().resolve(false);
            for (i = 0; i < size; ++i) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                if (bundle.isResolved() || bundle == this.framework.systemBundle) continue;
                BundleDescription changedBundleDes = bundle.getBundleDescription();
                if (changedBundleDes == null) {
                    this.framework.publishFrameworkEvent(2, bundle, new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_STATE", bundle.getLocation())));
                }
                if (!changedBundleDes.isResolved()) continue;
                if (bundle.isFragment()) {
                    BundleHost host = (BundleHost)this.framework.getBundle(changedBundleDes.getHost().getSupplier().getBundleId());
                    if (((BundleFragment)bundle).setHost(host)) {
                        bundle.resolve(changedBundleDes.isSingleton());
                    }
                } else {
                    bundle.resolve(changedBundleDes.isSingleton());
                }
                if (!bundle.isResolved()) continue;
                notify.add(bundle);
            }
            this.exportedPackages = this.getExportedPackages(this.exportedPackages);
            this.exportedBundles = this.getExportedBundles(this.exportedBundles);
        }
        for (int i = 0; i < notify.size(); ++i) {
            AbstractBundle bundle = (AbstractBundle)notify.elementAt(i);
            if (bundle == null) continue;
            this.framework.publishBundleEvent(bundle.isResolved() ? 32 : 64, bundle);
        }
        if (Debug.DEBUG_PACKAGEADMIN_TIMING) {
            this.cumulativeTime = this.cumulativeTime + System.currentTimeMillis() - start;
            DebugOptions.getDefault().setOption("org.eclipse.osgi/debug/packageadmin/timing/value", Long.toString(this.cumulativeTime));
        }
    }

    protected void unexportResources(BundleLoaderProxy proxy) {
        KeyedElement[] bundles = this.exportedBundles.elements();
        for (int i = 0; i < bundles.length; ++i) {
            BundleLoaderProxy loaderProxy = (BundleLoaderProxy)bundles[i];
            if (loaderProxy != proxy) continue;
            this.exportedBundles.remove(proxy);
        }
        KeyedElement[] packages = this.exportedPackages.elements();
        for (int i = 0; i < packages.length; ++i) {
            PackageSource source = (PackageSource)packages[i];
            BundleLoaderProxy sourceProxy = source.getSupplier();
            if (sourceProxy != proxy) continue;
            this.exportedPackages.remove(source);
        }
        proxy.setStale();
    }

    protected BundleDescription[] getBundleDescriptions(Vector graph) {
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>();
        int size = graph.size();
        for (int i = 0; i < size; ++i) {
            AbstractBundle bundle = (AbstractBundle)graph.elementAt(i);
            BundleDescription bundleDes = bundle.getBundleDescription();
            if (bundleDes == null) continue;
            result.add(bundleDes);
        }
        return result.toArray(new BundleDescription[result.size()]);
    }

    public ProvidingBundle[] getProvidingBundles(String symbolicName) {
        if (this.exportedBundles == null || this.exportedBundles.size() == 0) {
            return null;
        }
        this.framework.bundles.markDependancies();
        KeyedElement[] allSymbolicBundles = this.exportedBundles.elements();
        if (symbolicName == null) {
            if (allSymbolicBundles.length == 0) {
                return null;
            }
            ProvidingBundle[] result = new ProvidingBundle[allSymbolicBundles.length];
            System.arraycopy(allSymbolicBundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<ProvidingBundle> result = new ArrayList<ProvidingBundle>();
        for (int i = 0; i < allSymbolicBundles.length; ++i) {
            ProvidingBundle symBundle = (ProvidingBundle)allSymbolicBundles[i];
            if (!symBundle.getSymbolicName().equals(symbolicName)) continue;
            result.add(symBundle);
        }
        return result.toArray(new ProvidingBundle[result.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] bundles = this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null) {
            return null;
        }
        if (versionRange == null) {
            Bundle[] result = new AbstractBundle[bundles.length];
            System.arraycopy(bundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>(bundles.length);
        VersionRange range = new VersionRange(versionRange);
        for (int i = 0; i < bundles.length; ++i) {
            if (!range.isIncluded(bundles[i].getVersion())) continue;
            result.add(bundles[i]);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new AbstractBundle[result.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        Bundle host = ((AbstractBundle)bundle).getHost();
        if (host == null) {
            return null;
        }
        return new Bundle[]{host};
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected Class loadServiceClass(String className, AbstractBundle bundle) {
        try {
            return this.framework.adaptor.getBundleClassLoaderParent().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Class serviceClass;
            PackageSource exporter;
            String pkgname = BundleLoader.getPackageName(className);
            if (pkgname != null && (exporter = (PackageSource)this.exportedPackages.getByKey(pkgname)) != null && (serviceClass = exporter.getSupplier().getBundleLoader().findLocalClass(className)) != null) {
                return serviceClass;
            }
            if (bundle == null) {
                return null;
            }
            BundleLoader loader = bundle.getBundleLoader();
            if (!checkServiceClassSource) {
                try {
                    return loader.findClass(className);
                }
                catch (ClassNotFoundException e1) {
                    return null;
                }
            }
            if (restrictServiceClasses) {
                if (pkgname == null) {
                    pkgname = BundleLoader.DEFAULT_PACKAGE;
                }
                if (loader.getProvidedPackage(pkgname) != null) {
                    return null;
                }
            }
            if ((serviceClass = loader.findLocalClass(className)) == null || bundle.getBundleId() == 0L) {
                return serviceClass;
            }
            return serviceClass.getClassLoader() == loader.createClassLoader() ? serviceClass : null;
        }
    }
}

