/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.msg;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageFormat {
    protected ResourceBundle bundle;
    protected Locale locale;

    public MessageFormat(String bundleName) {
        this.init(bundleName, Locale.getDefault(), this.getClass());
    }

    public MessageFormat(String bundleName, Locale locale) {
        this.init(bundleName, locale, this.getClass());
    }

    public MessageFormat(String bundleName, Locale locale, Class clazz) {
        this.init(bundleName, locale, clazz);
    }

    protected void init(final String bundleName, final Locale locale, final Class clazz) {
        this.bundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader loader = clazz.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                try {
                    return ResourceBundle.getBundle(bundleName, locale, loader);
                }
                catch (MissingResourceException e) {
                    return null;
                }
            }
        });
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getString(String msg) {
        if (this.bundle == null) {
            return msg;
        }
        try {
            return this.bundle.getString(msg);
        }
        catch (MissingResourceException e) {
            return msg;
        }
    }

    public String getString(String msg, Object arg) {
        return this.getString(msg, new Object[]{arg});
    }

    public String getString(String msg, int arg) {
        return this.getString(msg, new Object[]{Integer.toString(arg)});
    }

    public String getString(String msg, char arg) {
        return this.getString(msg, new Object[]{String.valueOf(arg)});
    }

    public String getString(String msg, Object arg1, Object arg2) {
        return this.getString(msg, new Object[]{arg1, arg2});
    }

    public String getString(String msg, Object[] args) {
        String format = msg;
        if (this.bundle != null) {
            try {
                format = this.bundle.getString(msg);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return MessageFormat.format(format, args);
    }

    public static String format(String format, Object[] args) {
        StringBuffer answer = new StringBuffer();
        String[] argStrings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argStrings[i] = args[i] == null ? "<null>" : args[i].toString();
        }
        int lastI = 0;
        int i = format.indexOf(123, 0);
        while (i >= 0) {
            if (i != 0 && format.charAt(i - 1) == '\\') {
                if (i != 1) {
                    answer.append(format.substring(lastI, i - 1));
                }
                answer.append('{');
                lastI = i + 1;
            } else if (i > format.length() - 3) {
                answer.append(format.substring(lastI, format.length()));
                lastI = format.length();
            } else {
                byte argnum = (byte)Character.digit(format.charAt(i + 1), 10);
                if (argnum < 0 || format.charAt(i + 2) != '}') {
                    answer.append(format.substring(lastI, i + 1));
                    lastI = i + 1;
                } else {
                    answer.append(format.substring(lastI, i));
                    if (argnum >= argStrings.length) {
                        answer.append("<missing argument>");
                    } else {
                        answer.append(argStrings[argnum]);
                    }
                    lastI = i + 3;
                }
            }
            i = format.indexOf(123, lastI);
        }
        if (lastI < format.length()) {
            answer.append(format.substring(lastI, format.length()));
        }
        return answer.toString();
    }
}

