/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocument;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocumentManager;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocumentPartitioner;
import org.eclipse.debug.internal.ui.views.console.ConsoleLineNotifier;
import org.eclipse.debug.internal.ui.views.console.WorkspaceOperationRunner;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class ConsoleDocumentProvider
extends AbstractDocumentProvider {
    private WorkspaceOperationRunner fOperationRunner;

    protected IDocument createDocument(Object element) {
        if (element instanceof IProcess) {
            IProcess process = (IProcess)element;
            IConsoleColorProvider colorProvider = this.getColorProvider(process);
            ConsoleDocument doc = new ConsoleDocument(colorProvider);
            ConsoleDocumentPartitioner partitioner = new ConsoleDocumentPartitioner(process, colorProvider);
            ConsoleLineNotifier lineNotifier = this.getLineNotifier(process);
            partitioner.connect((IDocument)doc);
            if (lineNotifier != null) {
                partitioner.connectLineNotifier(lineNotifier);
            }
            return doc;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(Object element) {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) {
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        ConsoleDocument document = (ConsoleDocument)info.fDocument;
        document.getDocumentPartitioner().disconnect();
        super.disposeElementInfo(element, info);
    }

    protected IConsoleColorProvider getColorProvider(IProcess process) {
        String type = process.getAttribute(IProcess.ATTR_PROCESS_TYPE);
        IConsoleColorProvider colorProvider = null;
        if (type != null) {
            colorProvider = this.getConsoleDocumentManager().getColorProvider(type);
        }
        if (colorProvider == null) {
            colorProvider = new ConsoleColorProvider();
        }
        return colorProvider;
    }

    protected ConsoleLineNotifier getLineNotifier(IProcess process) {
        String type = process.getAttribute(IProcess.ATTR_PROCESS_TYPE);
        if (type != null) {
            return this.getConsoleDocumentManager().newLineNotifier(type);
        }
        return null;
    }

    private ConsoleDocumentManager getConsoleDocumentManager() {
        return DebugUIPlugin.getDefault().getConsoleDocumentManager();
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(monitor);
        return this.fOperationRunner;
    }
}

