/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSTagElement;
import org.eclipse.team.internal.ccvs.ui.model.RemoteModule;
import org.eclipse.team.internal.ccvs.ui.model.RepositoryLocationSchedulingRule;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class VersionCategory
extends CVSModelElement
implements IAdaptable,
IDeferredWorkbenchAdapter {
    private ICVSRepositoryLocation repository;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;
    static /* synthetic */ Class class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter;

    public VersionCategory(ICVSRepositoryLocation repo) {
        this.repository = repo;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = VersionCategory.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
            return this;
        }
        if (adapter == (class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter == null ? (class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter = VersionCategory.class$("org.eclipse.ui.progress.IDeferredWorkbenchAdapter")) : class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter)) {
            return this;
        }
        return null;
    }

    public Object[] fetchChildren(Object o, IProgressMonitor monitor) throws TeamException {
        if (CVSUIPlugin.getPlugin().getRepositoryManager().isDisplayingProjectVersions(this.repository)) {
            return this.getProjectVersionChildren(o, monitor);
        }
        return this.getVersionTagChildren(o, monitor);
    }

    private Object[] getVersionTagChildren(Object o, IProgressMonitor monitor) throws CVSException {
        CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(this.repository, this.getWorkingSet(), 2, monitor);
        Object[] versionElements = new CVSTagElement[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            versionElements[i] = new CVSTagElement(tags[i], this.repository);
        }
        return versionElements;
    }

    private Object[] getProjectVersionChildren(Object o, IProgressMonitor monitor) throws TeamException {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        ICVSRemoteResource[] resources = CVSUIPlugin.getPlugin().getRepositoryManager().getFoldersForTag(this.repository, CVSTag.DEFAULT, monitor);
        if (this.getWorkingSet() != null) {
            resources = CVSUIPlugin.getPlugin().getRepositoryManager().filterResources(this.getWorkingSet(), resources);
        }
        Object[] modules = new Object[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            modules[i] = new RemoteModule((ICVSRemoteFolder)resources[i], this);
        }
        return modules;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/versions_rep.gif");
    }

    public String getLabel(Object o) {
        return Policy.bind("VersionCategory.Versions_1");
    }

    public Object getParent(Object o) {
        return this.repository;
    }

    public ICVSRepositoryLocation getRepository(Object o) {
        return this.repository;
    }

    public void fetchDeferredChildren(Object o, IElementCollector collector, IProgressMonitor monitor) {
        try {
            collector.add(this.fetchChildren(o, monitor), monitor);
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object element) {
        return new RepositoryLocationSchedulingRule(this.repository);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

