/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DefaultInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
DisposeListener {
    private static final int BORDER = 1;
    private Shell fShell;
    private StyledText fText;
    private IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Font fStatusTextFont;

    public DefaultInformationControl(Shell parent, int shellStyle, int style, IInformationPresenter presenter) {
        this(parent, shellStyle, style, presenter, null);
    }

    public DefaultInformationControl(Shell parent, int shellStyle, int style, IInformationPresenter presenter, String statusFieldText) {
        int border;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (shellStyle & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(display.getSystemColor(29));
        }
        this.fText = new StyledText((Composite)composite, 0xA | style);
        gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(display.getSystemColor(28));
        this.fText.setBackground(display.getSystemColor(29));
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    DefaultInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fPresenter = presenter;
        if (statusFieldText != null) {
            Label separator = new Label((Composite)composite, 259);
            separator.setLayoutData((Object)new GridData(768));
            Label statusField = new Label((Composite)composite, 131072);
            statusField.setText(statusFieldText);
            Font font = statusField.getFont();
            FontData[] fontDatas = font.getFontData();
            for (int i = 0; i < fontDatas.length; ++i) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
            }
            this.fStatusTextFont = new Font((Device)statusField.getDisplay(), fontDatas);
            statusField.setFont(this.fStatusTextFont);
            gd = new GridData(802);
            statusField.setLayoutData((Object)gd);
            statusField.setForeground(display.getSystemColor(17));
            statusField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
    }

    public DefaultInformationControl(Shell parent, int style, IInformationPresenter presenter) {
        this(parent, 8, style, presenter);
    }

    public DefaultInformationControl(Shell parent, int style, IInformationPresenter presenter, String statusFieldText) {
        this(parent, 8, style, presenter, statusFieldText);
    }

    public DefaultInformationControl(Shell parent) {
        this(parent, 0, null);
    }

    public DefaultInformationControl(Shell parent, IInformationPresenter presenter) {
        this(parent, 0, presenter);
    }

    public void setInformation(String content) {
        if (this.fPresenter == null) {
            this.fText.setText(content);
        } else {
            this.fPresentation.clear();
            content = this.fPresenter.updatePresentation(this.fShell.getDisplay(), content, this.fPresentation, this.fMaxWidth, this.fMaxHeight);
            if (content != null) {
                this.fText.setText(content);
                TextPresentation.applyTextPresentation(this.fPresentation, this.fText);
            } else {
                this.fText.setText("");
            }
        }
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fShell = null;
        this.fText = null;
        this.fStatusTextFont = null;
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fText.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public Rectangle computeTrim() {
        return this.fShell.computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    public static interface IInformationPresenter {
        public String updatePresentation(Display var1, String var2, TextPresentation var3, int var4, int var5);
    }
}

