/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class BaseBuildAction
implements IObjectActionDelegate,
IPreferenceConstants {
    protected IFile fManifestFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!this.fManifestFile.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IWorkspaceRunnable wop = new IWorkspaceRunnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            BaseBuildAction.access$100(1.access$000(this.this$1), monitor);
                        }
                        catch (InvocationTargetException e) {
                            PDEPlugin.logException(e);
                        }
                    }
                };
                try {
                    PDEPlugin.getWorkspace().run(wop, monitor);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            static /* synthetic */ BaseBuildAction access$000(1 x0) {
                return x0.BaseBuildAction.this;
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IFile) {
            this.fManifestFile = (IFile)obj;
        }
    }

    private void doBuild(IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        monitor.beginTask(PDEPlugin.getResourceString("BuildAction.Validate"), 4);
        if (!BaseBuildAction.ensureValid(this.fManifestFile, monitor)) {
            monitor.done();
            return;
        }
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString("BuildAction.Generate"));
        this.makeScripts(monitor);
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString("BuildAction.Update"));
        this.refreshLocal(monitor);
        monitor.worked(1);
        this.setDefaultValues();
        monitor.worked(1);
    }

    protected abstract void makeScripts(IProgressMonitor var1) throws InvocationTargetException, CoreException;

    public static boolean ensureValid(IFile file, IProgressMonitor monitor) throws CoreException {
        IProject project = file.getProject();
        if (!project.getWorkspace().isAutoBuilding()) {
            String builderID = "feature.xml".equals(file.getName()) ? "org.eclipse.pde.FeatureBuilder" : "org.eclipse.pde.ManifestBuilder";
            project.build(10, builderID, null, monitor);
        }
        if (BaseBuildAction.hasErrors(file)) {
            MessageDialog.openError(null, (String)PDEPlugin.getResourceString("BuildAction.ErrorDialog.Title"), (String)PDEPlugin.getResourceString("BuildAction.ErrorDialog.Message"));
            return false;
        }
        return true;
    }

    public static boolean hasErrors(IFile file) throws CoreException {
        IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        for (int i = 0; i < markers.length; ++i) {
            Object att = markers[i].getAttribute("severity");
            if (att == null || !(att instanceof Integer) || (Integer)att != 2) continue;
            return true;
        }
        return false;
    }

    protected void refreshLocal(IProgressMonitor monitor) throws CoreException {
        IProject project = this.fManifestFile.getProject();
        project.refreshLocal(1, monitor);
        IFile file = project.getFile("dev.properties");
        if (file.exists()) {
            file.delete(true, false, monitor);
        }
        project.refreshLocal(1, monitor);
    }

    private void setDefaultValues() {
        IProject project = this.fManifestFile.getProject();
        IFile generatedFile = (IFile)project.findMember("build.xml");
        if (generatedFile == null) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy launchCopy;
            List configs = AntLaunchShortcut.findExistingLaunchConfigurations((IFile)generatedFile);
            if (configs.size() == 0) {
                ILaunchConfiguration config = AntLaunchShortcut.createDefaultLaunchConfiguration((IFile)generatedFile);
                launchCopy = config.getWorkingCopy();
            } else {
                launchCopy = ((ILaunchConfiguration)configs.get(0)).getWorkingCopy();
            }
            if (launchCopy == null) {
                return;
            }
            Map<String, String> properties = new HashMap();
            properties = launchCopy.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
            properties.put("basews", TargetPlatform.getWS());
            properties.put("baseos", TargetPlatform.getOS());
            properties.put("basearch", TargetPlatform.getOSArch());
            properties.put("basenl", TargetPlatform.getNL());
            properties.put("eclipse.running", "true");
            IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
            properties.put("javacFailOnError", store.getString("javacFailOnError"));
            properties.put("javacDebugInfo", store.getBoolean("javacDebugInfo") ? "on" : "off");
            properties.put("javacVerbose", store.getString("javacVerbose"));
            Preferences pref = JavaCore.getPlugin().getPluginPreferences();
            properties.put("javacSource", pref.getString("org.eclipse.jdt.core.compiler.source"));
            properties.put("javacTarget", pref.getString("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
            properties.put("bootclasspath", BaseBuildAction.getBootClasspath());
            launchCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
            launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, (String)null);
            launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, (String)null);
            launchCopy.doSave();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static String getBootClasspath() {
        StringBuffer buffer = new StringBuffer();
        LibraryLocation[] locations = JavaRuntime.getLibraryLocations((IVMInstall)JavaRuntime.getDefaultVMInstall());
        for (int i = 0; i < locations.length; ++i) {
            buffer.append(locations[i].getSystemLibraryPath().toOSString());
            if (i >= locations.length - 1) continue;
            buffer.append(";");
        }
        return buffer.toString();
    }

    static /* synthetic */ void access$100(BaseBuildAction x0, IProgressMonitor x1) throws CoreException, InvocationTargetException {
        x0.doBuild(x1);
    }
}

