/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.launcher.TracingLauncherTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TracingPropertySource {
    private IPluginModelBase fModel;
    private Vector fDescriptors;
    private Hashtable fTemplate;
    private Hashtable fValues;
    private Hashtable fDvalues;
    private static final String[] fBooleanChoices = new String[]{"false", "true"};
    private Properties fMasterOptions;
    private boolean fModified;
    private TracingLauncherTab fTab;

    public TracingPropertySource(IPluginModelBase model, Properties masterOptions, Hashtable template, TracingLauncherTab tab) {
        this.fModel = model;
        this.fMasterOptions = masterOptions;
        this.fTemplate = template;
        this.fTab = tab;
        this.fValues = new Hashtable();
        this.fDvalues = new Hashtable();
    }

    public IPluginModelBase getModel() {
        return this.fModel;
    }

    private Object[] getSortedKeys(int size, Enumeration keys) {
        Object[] keyArray = new Object[size];
        int i = 0;
        Enumeration enumeration = this.fTemplate.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            keyArray[i++] = key;
        }
        Arrays.sort(keyArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                return TracingPropertySource.this.compareKeys(o1, o2);
            }
        });
        return keyArray;
    }

    private int compareKeys(Object o1, Object o2) {
        String s1 = (String)o1;
        String s2 = (String)o2;
        return s1.compareTo(s2);
    }

    public void createContents(Composite parent) {
        this.fDescriptors = new Vector();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        boolean bordersNeeded = false;
        Object[] sortedKeys = this.getSortedKeys(this.fTemplate.size(), this.fTemplate.keys());
        for (int i = 0; i < sortedKeys.length; ++i) {
            PropertyEditor editor;
            String key = (String)sortedKeys[i];
            Path path = new Path(key);
            path = path.removeFirstSegments(1);
            String shortKey = path.toString();
            String value = (String)this.fTemplate.get(key);
            String lvalue = null;
            String masterValue = this.fMasterOptions.getProperty(key);
            if (value != null) {
                lvalue = value.toLowerCase();
            }
            if (lvalue != null && (lvalue.equals("true") || lvalue.equals("false"))) {
                editor = new BooleanEditor(shortKey, shortKey);
                Integer dvalue = new Integer(lvalue.equals("true") ? 1 : 0);
                this.fDvalues.put(shortKey, dvalue);
                if (masterValue != null) {
                    Integer mvalue = new Integer(masterValue.equals("true") ? 1 : 0);
                    this.fValues.put(shortKey, mvalue);
                }
            } else {
                editor = new TextEditor(shortKey, shortKey);
                this.fDvalues.put(shortKey, value != null ? value : "");
                if (masterValue != null) {
                    this.fValues.put(shortKey, masterValue);
                }
                bordersNeeded = true;
            }
            editor.create(parent);
            editor.initialize();
            this.fDescriptors.add(editor);
            if (!bordersNeeded) continue;
            this.fTab.getToolkit().paintBordersFor(parent);
        }
    }

    public void save() {
        String pid = this.fModel.getPluginBase().getId();
        Enumeration enumeration = this.fValues.keys();
        while (enumeration.hasMoreElements()) {
            String shortKey = (String)enumeration.nextElement();
            Object value = this.fValues.get(shortKey);
            String svalue = value.toString();
            if (value instanceof Integer) {
                svalue = fBooleanChoices[(Integer)value];
            }
            IPath path = new Path(pid).append(shortKey);
            this.fMasterOptions.setProperty(path.toString(), svalue);
        }
        this.fModified = false;
    }

    public void dispose() {
    }

    public boolean isModified() {
        return this.fModified;
    }

    private class TextEditor
    extends PropertyEditor {
        private Text text;

        public TextEditor(String key, String label) {
            super(key, label);
        }

        public void create(Composite parent) {
            Label label = TracingPropertySource.this.fTab.getToolkit().createLabel(parent, this.getLabel());
            TableWrapData td = new TableWrapData();
            td.valign = 32;
            label.setLayoutData((Object)td);
            this.text = TracingPropertySource.this.fTab.getToolkit().createText(parent, "");
            td = new TableWrapData(256);
            this.text.setLayoutData((Object)td);
        }

        public void update() {
            String value = (String)TracingPropertySource.this.fValues.get(this.getKey());
            this.text.setText(value);
        }

        public void initialize() {
            this.update();
            this.text.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ TextEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.valueModified(TextEditor.access$400(this.this$1).getText());
                }
            });
        }

        static /* synthetic */ Text access$400(TextEditor x0) {
            return x0.text;
        }
    }

    private class BooleanEditor
    extends PropertyEditor {
        private Button checkbox;

        public BooleanEditor(String key, String label) {
            super(key, label);
        }

        public void create(Composite parent) {
            this.checkbox = TracingPropertySource.this.fTab.getToolkit().createButton(parent, this.getLabel(), 32);
            TableWrapData td = new TableWrapData();
            td.colspan = 2;
            this.checkbox.setLayoutData((Object)td);
        }

        public void update() {
            Integer value = (Integer)TracingPropertySource.this.fValues.get(this.getKey());
            this.checkbox.setSelection(value == 1);
        }

        public void initialize() {
            this.update();
            this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ BooleanEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    int value = BooleanEditor.access$300(this.this$1).getSelection() ? 1 : 0;
                    this.this$1.valueModified(new Integer(value));
                }
            });
        }

        static /* synthetic */ Button access$300(BooleanEditor x0) {
            return x0.checkbox;
        }
    }

    private abstract class PropertyEditor {
        private String key;
        private String label;

        public PropertyEditor(String key, String label) {
            this.key = key;
            this.label = label;
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        abstract void create(Composite var1);

        abstract void update();

        abstract void initialize();

        protected void valueModified(Object value) {
            TracingPropertySource.this.fValues.put(this.getKey(), value);
            TracingPropertySource.this.fModified = true;
            TracingPropertySource.this.fTab.updateLaunchConfigurationDialog();
        }
    }
}

