/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.workingset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkingSet {
    private String name;
    private List elements;

    public WorkingSet(String name) {
        this(name, (List)null);
    }

    public WorkingSet(String name, List elements) {
        this.name = name;
        if (elements == null) {
            elements = new ArrayList();
        }
        this.elements = elements;
    }

    public WorkingSet(String name, AdaptableHelpResource[] elements) {
        this.name = name;
        if (elements == null) {
            elements = new AdaptableHelpResource[]{};
        }
        this.elements = new ArrayList(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.elements.add(elements[i]);
        }
    }

    public void removeElement(AdaptableHelpResource element) {
        this.elements.remove(element);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            return;
        }
        this.name = newName;
    }

    public AdaptableHelpResource[] getElements() {
        AdaptableHelpResource[] array = new AdaptableHelpResource[this.elements.size()];
        this.elements.toArray(array);
        return array;
    }

    public void setElements(AdaptableHelpResource[] elements) {
        this.elements = new ArrayList(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.elements.add(elements[i]);
        }
    }

    public void saveState(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element ws = doc.createElement("workingSet");
        ws.setAttribute("name", this.name);
        parent.appendChild(ws);
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Element child = doc.createElement("item");
            AdaptableHelpResource helpResource = (AdaptableHelpResource)it.next();
            helpResource.saveState(child);
            ws.appendChild(child);
        }
    }
}

