/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = sourceLength - 1;
    }

    public void abort(int abortLevel, IProblem problem) {
        switch (abortLevel) {
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, problem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = 0; i < count; ++i) {
                    this.types[i].analyseCode(this.scope);
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit e) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        if (this.types != null) {
            int i;
            int max = this.types.length;
            for (i = 0; i < max; ++i) {
                this.cleanUp(this.types[i]);
            }
            max = this.localTypeCount;
            for (i = 0; i < max; ++i) {
                LocalTypeBinding localType = this.localTypes[i];
                localType.scope = null;
            }
        }
        ClassFile[] classFiles = this.compilationResult.getClassFiles();
        int max = classFiles.length;
        for (int i = 0; i < max; ++i) {
            ClassFile classFile = classFiles[i];
            classFile.referenceBinding = null;
            classFile.codeStream = null;
            classFile.innerClassesBindings = null;
        }
    }

    private void cleanUp(TypeDeclaration type) {
        if (type.memberTypes != null) {
            int max = type.memberTypes.length;
            for (int i = 0; i < max; ++i) {
                this.cleanUp(type.memberTypes[i]);
            }
        }
        if (type.binding != null) {
            type.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            int max = this.scope.imports.length;
            for (int i = 0; i < max; ++i) {
                ImportBinding importBinding = this.scope.imports[i];
                ImportReference importReference = importBinding.reference;
                if (importReference == null || importReference.used) continue;
                this.scope.problemReporter().unusedImport(importReference);
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public TypeDeclaration declarationOfType(char[][] typeName) {
        for (int i = 0; i < this.types.length; ++i) {
            TypeDeclaration typeDecl = this.types[i].declarationOfType(typeName);
            if (typeDecl == null) continue;
            return typeDecl;
        }
        return null;
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = 0; i < count; ++i) {
                    this.types[i].ignoreFurtherInvestigation = true;
                    this.types[i].generateCode(this.scope);
                }
            }
            return;
        }
        try {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = 0; i < count; ++i) {
                    this.types[i].generateCode(this.scope);
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int end;
            char[] fileName = this.compilationResult.getFileName();
            int start = CharOperation.lastIndexOf('/', fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
                start = CharOperation.lastIndexOf('\\', fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray(fileName, start, end);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int i;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(indent, output).append("package ");
            this.currentPackage.print(0, output, false).append(";\n");
        }
        if (this.imports != null) {
            for (i = 0; i < this.imports.length; ++i) {
                CompilationUnitDeclaration.printIndent(indent, output).append("import ");
                this.imports[i].print(0, output).append(";\n");
            }
        }
        if (this.types != null) {
            for (i = 0; i < this.types.length; ++i) {
                this.types[i].print(indent, output).append("\n");
            }
        }
        return output;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int max = this.localTypeCount;
        for (int i = 0; i < max; ++i) {
            LocalTypeBinding localType = this.localTypes[i];
            if ((localType.scope.referenceType().bits & Integer.MIN_VALUE) == 0) continue;
            localType.updateInnerEmulationDependents();
        }
    }

    public void record(LocalTypeBinding localType) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localType;
    }

    public void resolve() {
        try {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = 0; i < count; ++i) {
                    this.types[i].resolve(this.scope);
                }
            }
            if (!this.compilationResult.hasSyntaxError()) {
                this.checkUnusedImports();
            }
        }
        catch (AbortCompilationUnit e) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, this.scope)) {
                int i;
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(visitor, this.scope);
                }
                if (this.imports != null) {
                    int importLength = this.imports.length;
                    for (i = 0; i < importLength; ++i) {
                        this.imports[i].traverse(visitor, this.scope);
                    }
                }
                if (this.types != null) {
                    int typesLength = this.types.length;
                    for (i = 0; i < typesLength; ++i) {
                        this.types[i].traverse(visitor, this.scope);
                    }
                }
            }
            visitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }
}

