/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.XMLWriter;
import org.eclipse.jdt.internal.core.util.Util;
import org.w3c.dom.Element;

public class ClasspathEntry
implements IClasspathEntry {
    public int entryKind;
    public int contentKind;
    public IPath path;
    public IPath[] inclusionPatterns;
    private char[][] fullCharInclusionPatterns;
    public IPath[] exclusionPatterns;
    private char[][] fullCharExclusionPatterns;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private String rootID;
    public static final IPath[] INCLUDE_ALL = new IPath[0];
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    public IPath sourceAttachmentPath;
    public IPath sourceAttachmentRootPath;
    public IPath specificOutputLocation;
    public static final int K_OUTPUT = 10;
    public boolean isExported;

    public ClasspathEntry(int contentKind, int entryKind, IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath specificOutputLocation, boolean isExported) {
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.inclusionPatterns = inclusionPatterns;
        this.fullCharInclusionPatterns = inclusionPatterns != INCLUDE_ALL && inclusionPatterns.length > 0 ? UNINIT_PATTERNS : (char[][])null;
        this.exclusionPatterns = exclusionPatterns;
        this.fullCharExclusionPatterns = exclusionPatterns.length > 0 ? UNINIT_PATTERNS : (char[][])null;
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.specificOutputLocation = specificOutputLocation;
        this.isExported = isExported;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            for (int i = 0; i < length; ++i) {
                this.fullCharExclusionPatterns[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
            }
        }
        return this.fullCharExclusionPatterns;
    }

    public char[][] fullInclusionPatternChars() {
        if (this.fullCharInclusionPatterns == UNINIT_PATTERNS) {
            int length = this.inclusionPatterns.length;
            this.fullCharInclusionPatterns = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            for (int i = 0; i < length; ++i) {
                this.fullCharInclusionPatterns[i] = prefixPath.append(this.inclusionPatterns[i]).toString().toCharArray();
            }
        }
        return this.fullCharInclusionPatterns;
    }

    public void elementEncode(XMLWriter writer, IPath projectPath, boolean indent, boolean newLine) {
        int i;
        int max;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("kind", ClasspathEntry.kindToString(this.entryKind));
        IPath xmlPath = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
            if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            } else {
                xmlPath = xmlPath.makeAbsolute();
            }
        }
        parameters.put("path", String.valueOf(xmlPath));
        if (this.sourceAttachmentPath != null) {
            xmlPath = this.sourceAttachmentPath;
            if (this.entryKind != 4 && projectPath != null && projectPath.isPrefixOf(xmlPath) && xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            }
            parameters.put("sourcepath", String.valueOf(xmlPath));
        }
        if (this.sourceAttachmentRootPath != null) {
            parameters.put("rootpath", String.valueOf(this.sourceAttachmentRootPath));
        }
        if (this.isExported) {
            parameters.put("exported", "true");
        }
        if (this.inclusionPatterns != null && this.inclusionPatterns.length > 0) {
            StringBuffer includeRule = new StringBuffer(10);
            max = this.inclusionPatterns.length;
            for (i = 0; i < max; ++i) {
                if (i > 0) {
                    includeRule.append('|');
                }
                includeRule.append(this.inclusionPatterns[i]);
            }
            parameters.put("including", String.valueOf(includeRule));
        }
        if (this.exclusionPatterns != null && this.exclusionPatterns.length > 0) {
            StringBuffer excludeRule = new StringBuffer(10);
            max = this.exclusionPatterns.length;
            for (i = 0; i < max; ++i) {
                if (i > 0) {
                    excludeRule.append('|');
                }
                excludeRule.append(this.exclusionPatterns[i]);
            }
            parameters.put("excluding", String.valueOf(excludeRule));
        }
        if (this.specificOutputLocation != null) {
            IPath outputLocation = this.specificOutputLocation.removeFirstSegments(1);
            outputLocation = outputLocation.makeRelative();
            parameters.put("output", String.valueOf(outputLocation));
        }
        writer.printTag("classpathentry", parameters, indent, newLine, true);
    }

    public static IClasspathEntry elementDecode(Element element, IJavaProject project) {
        char[][] patterns;
        int patternCount;
        char[][] patterns2;
        int patternCount2;
        Path sourceAttachmentPath;
        IPath projectPath = project.getProject().getFullPath();
        String kindAttr = element.getAttribute("kind");
        String pathAttr = element.getAttribute("path");
        Path path = new Path(pathAttr);
        int kind = ClasspathEntry.kindFromString(kindAttr);
        if (kind != 4 && kind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path path2 = sourceAttachmentPath = element.hasAttribute("sourcepath") ? new Path(element.getAttribute("sourcepath")) : null;
        if (kind != 4 && sourceAttachmentPath != null && !sourceAttachmentPath.isAbsolute()) {
            sourceAttachmentPath = projectPath.append((IPath)sourceAttachmentPath);
        }
        Path sourceAttachmentRootPath = element.hasAttribute("rootpath") ? new Path(element.getAttribute("rootpath")) : null;
        boolean isExported = element.getAttribute("exported").equals("true");
        String inclusion = element.getAttribute("including");
        IPath[] inclusionPatterns = INCLUDE_ALL;
        if (!inclusion.equals("") && (patternCount2 = (patterns2 = CharOperation.splitOn('|', inclusion.toCharArray())).length) > 0) {
            inclusionPatterns = new IPath[patternCount2];
            for (int j = 0; j < patterns2.length; ++j) {
                inclusionPatterns[j] = new Path(new String(patterns2[j]));
            }
        }
        String exclusion = element.getAttribute("excluding");
        IPath[] exclusionPatterns = EXCLUDE_NONE;
        if (!exclusion.equals("") && (patternCount = (patterns = CharOperation.splitOn('|', exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            for (int j = 0; j < patterns.length; ++j) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
            }
        }
        IPath outputLocation = element.hasAttribute("output") ? projectPath.append(element.getAttribute("output")) : null;
        switch (kind) {
            case 2: {
                return JavaCore.newProjectEntry((IPath)path, isExported);
            }
            case 1: {
                return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, isExported);
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getElementName())) {
                    return JavaCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, outputLocation);
                }
                if (path.segmentCount() == 1) {
                    return JavaCore.newProjectEntry((IPath)path, isExported);
                }
                return JavaCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, outputLocation);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, isExported);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)path, isExported);
            }
            case 10: {
                if (!path.isAbsolute()) {
                    return null;
                }
                return new ClasspathEntry(10, 1, (IPath)path, INCLUDE_ALL, EXCLUDE_NONE, null, null, null, false);
            }
        }
        throw new Assert.AssertionFailedException(Util.bind("classpath.unknownKind", kindAttr));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IClasspathEntry) {
            IPath[] otherExcludes;
            IClasspathEntry otherEntry = (IClasspathEntry)object;
            if (this.contentKind != otherEntry.getContentKind()) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != otherEntry.isExported()) {
                return false;
            }
            if (!this.path.equals(otherEntry.getPath())) {
                return false;
            }
            IPath otherPath = otherEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? otherPath != null : !this.sourceAttachmentPath.equals(otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentRootPath();
            if (this.sourceAttachmentRootPath == null ? otherPath != null : !this.sourceAttachmentRootPath.equals(otherPath)) {
                return false;
            }
            IPath[] otherIncludes = otherEntry.getInclusionPatterns();
            if (this.inclusionPatterns != otherIncludes) {
                if (this.inclusionPatterns == null) {
                    return false;
                }
                int includeLength = this.inclusionPatterns.length;
                if (otherIncludes == null || otherIncludes.length != includeLength) {
                    return false;
                }
                for (int i = 0; i < includeLength; ++i) {
                    if (this.inclusionPatterns[i].toString().equals(otherIncludes[i].toString())) continue;
                    return false;
                }
            }
            if (this.exclusionPatterns != (otherExcludes = otherEntry.getExclusionPatterns())) {
                if (this.exclusionPatterns == null) {
                    return false;
                }
                int excludeLength = this.exclusionPatterns.length;
                if (otherExcludes == null || otherExcludes.length != excludeLength) {
                    return false;
                }
                for (int i = 0; i < excludeLength; ++i) {
                    if (this.exclusionPatterns[i].toString().equals(otherExcludes[i].toString())) continue;
                    return false;
                }
            }
            otherPath = otherEntry.getOutputLocation();
            return !(this.specificOutputLocation == null ? otherPath != null : !this.specificOutputLocation.equals(otherPath));
        }
        return false;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IPath[] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public IPath getOutputLocation() {
        return this.specificOutputLocation;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isExported() {
        return this.isExported;
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("output")) {
            return 10;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
            case 10: {
                return "output";
            }
        }
        return "unknown";
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath().toString());
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CPE_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CPE_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CPE_SOURCE");
                break;
            }
            case 4: {
                buffer.append("CPE_VARIABLE");
                break;
            }
            case 5: {
                buffer.append("CPE_CONTAINER");
            }
        }
        buffer.append("][");
        switch (this.getContentKind()) {
            case 2: {
                buffer.append("K_BINARY");
                break;
            }
            case 1: {
                buffer.append("K_SOURCE");
                break;
            }
            case 10: {
                buffer.append("K_OUTPUT");
            }
        }
        buffer.append(']');
        if (this.getSourceAttachmentPath() != null) {
            buffer.append("[sourcePath:");
            buffer.append(this.getSourceAttachmentPath());
            buffer.append(']');
        }
        if (this.getSourceAttachmentRootPath() != null) {
            buffer.append("[rootPath:");
            buffer.append(this.getSourceAttachmentRootPath());
            buffer.append(']');
        }
        buffer.append("[isExported:");
        buffer.append(this.isExported);
        buffer.append(']');
        IPath[] patterns = this.getInclusionPatterns();
        int length = patterns == null ? 0 : patterns.length;
        if (length > 0) {
            buffer.append("[including:");
            for (i = 0; i < length; ++i) {
                buffer.append(patterns[i]);
                if (i == length - 1) continue;
                buffer.append('|');
            }
            buffer.append(']');
        }
        if ((length = (patterns = this.getExclusionPatterns()) == null ? 0 : patterns.length) > 0) {
            buffer.append("[excluding:");
            for (i = 0; i < length; ++i) {
                buffer.append(patterns[i]);
                if (i == length - 1) continue;
                buffer.append('|');
            }
            buffer.append(']');
        }
        if (this.getOutputLocation() != null) {
            buffer.append("[output:");
            buffer.append(this.getOutputLocation());
            buffer.append(']');
        }
        return buffer.toString();
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public IClasspathEntry getResolvedEntry() {
        return JavaCore.getResolvedClasspathEntry(this);
    }

    public static IJavaModelStatus validateClasspath(IJavaProject javaProject, IClasspathEntry[] rawClasspath, IPath projectOutputLocation) {
        String entryPathMsg;
        boolean isProjectRelative;
        int kind;
        int i;
        IClasspathEntry resolvedEntry;
        int i2;
        IClasspathEntry[] classpath;
        IProject project = javaProject.getProject();
        IPath projectPath = project.getFullPath();
        String projectName = javaProject.getElementName();
        if (projectOutputLocation == null) {
            return new JavaModelStatus(970);
        }
        if (projectOutputLocation.isAbsolute()) {
            if (!projectPath.isPrefixOf(projectOutputLocation)) {
                return new JavaModelStatus(971, (IJavaElement)javaProject, projectOutputLocation.toString());
            }
        } else {
            return new JavaModelStatus(972, projectOutputLocation);
        }
        boolean hasSource = false;
        boolean hasLibFolder = false;
        if (rawClasspath == null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        try {
            classpath = ((JavaProject)javaProject).getResolvedClasspath(rawClasspath, null, true, false, null);
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        int length = classpath.length;
        int outputCount = 1;
        IPath[] outputLocations = new IPath[length + 1];
        boolean[] allowNestingInOutputLocations = new boolean[length + 1];
        outputLocations[0] = projectOutputLocation;
        IPath potentialNestedOutput = null;
        int sourceEntryCount = 0;
        boolean disableExclusionPatterns = "disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.exclusionPatterns", true));
        boolean disableCustomOutputLocations = "disabled".equals(javaProject.getOption("org.eclipse.jdt.core.classpath.multipleOutputLocations", true));
        block13: for (i2 = 0; i2 < length; ++i2) {
            resolvedEntry = classpath[i2];
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    ++sourceEntryCount;
                    if (disableExclusionPatterns && (resolvedEntry.getInclusionPatterns() != null && resolvedEntry.getInclusionPatterns().length > 0 || resolvedEntry.getExclusionPatterns() != null && resolvedEntry.getExclusionPatterns().length > 0)) {
                        return new JavaModelStatus(1002, (IJavaElement)javaProject, resolvedEntry.getPath());
                    }
                    IPath customOutput = resolvedEntry.getOutputLocation();
                    if (customOutput == null) continue block13;
                    if (disableCustomOutputLocations) {
                        return new JavaModelStatus(1003, (IJavaElement)javaProject, resolvedEntry.getPath());
                    }
                    if (customOutput.isAbsolute()) {
                        if (!javaProject.getPath().isPrefixOf(customOutput)) {
                            return new JavaModelStatus(971, (IJavaElement)javaProject, customOutput.toString());
                        }
                    } else {
                        return new JavaModelStatus(972, customOutput);
                    }
                    if (Util.indexOfMatchingPath(customOutput, outputLocations, outputCount) != -1) continue block13;
                    outputLocations[outputCount++] = customOutput;
                }
            }
        }
        for (i2 = 1; i2 < outputCount; ++i2) {
            IPath customOutput = outputLocations[i2];
            int index = Util.indexOfEnclosingPath(customOutput, outputLocations, outputCount);
            if (index == -1 || index == i2) continue;
            if (index == 0) {
                if (potentialNestedOutput != null) continue;
                potentialNestedOutput = customOutput;
                continue;
            }
            return new JavaModelStatus(964, Util.bind("classpath.cannotNestOutputInOutput", customOutput.makeRelative().toString(), outputLocations[index].makeRelative().toString()));
        }
        if (sourceEntryCount <= outputCount - 1) {
            allowNestingInOutputLocations[0] = true;
        } else if (potentialNestedOutput != null) {
            return new JavaModelStatus(964, Util.bind("classpath.cannotNestOutputInOutput", potentialNestedOutput.makeRelative().toString(), outputLocations[0].makeRelative().toString()));
        }
        block15: for (i2 = 0; i2 < length; ++i2) {
            resolvedEntry = classpath[i2];
            IPath path = resolvedEntry.getPath();
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    hasSource = true;
                    int index = Util.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) continue block15;
                    allowNestingInOutputLocations[index] = true;
                    continue block15;
                }
                case 1: {
                    hasLibFolder |= !org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(path.lastSegment());
                    int index = Util.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) continue block15;
                    allowNestingInOutputLocations[index] = true;
                }
            }
        }
        if (!hasSource && !hasLibFolder) {
            for (i2 = 0; i2 < outputCount; ++i2) {
                allowNestingInOutputLocations[i2] = true;
            }
        }
        HashSet<IPath> pathes = new HashSet<IPath>(length);
        for (i = 0; i < length; ++i) {
            IPath currentOutput;
            int j;
            IClasspathEntry entry = classpath[i];
            if (entry == null) continue;
            IPath entryPath = entry.getPath();
            kind = entry.getEntryKind();
            isProjectRelative = entryPath.segment(0).toString().equals(projectName);
            String string = entryPathMsg = isProjectRelative ? entryPath.removeFirstSegments(1).toString() : entryPath.makeRelative().toString();
            if (!pathes.add(entryPath)) {
                return new JavaModelStatus(977, Util.bind("classpath.duplicateEntryPath", entryPathMsg, projectName));
            }
            if (entryPath.equals(projectPath)) {
                if (kind != 2) continue;
                return new JavaModelStatus(979, Util.bind("classpath.cannotReferToItself", entryPath.makeRelative().toString()));
            }
            if (kind == 3 || kind == 1 && !org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(entryPath.lastSegment())) {
                for (int j2 = 0; j2 < classpath.length; ++j2) {
                    IClasspathEntry otherEntry = classpath[j2];
                    if (otherEntry == null) continue;
                    int otherKind = otherEntry.getEntryKind();
                    IPath otherPath = otherEntry.getPath();
                    if (entry == otherEntry || otherKind != 3 && (otherKind != 1 || org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(otherPath.lastSegment())) || !otherPath.isPrefixOf(entryPath) || otherPath.equals(entryPath)) continue;
                    char[][] inclusionPatterns = ((ClasspathEntry)otherEntry).fullInclusionPatternChars();
                    char[][] exclusionPatterns = ((ClasspathEntry)otherEntry).fullExclusionPatternChars();
                    if (Util.isExcluded(entryPath.append("*"), inclusionPatterns, exclusionPatterns, false)) continue;
                    String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                    if (Util.isExcluded(entryPath, inclusionPatterns, exclusionPatterns, false)) {
                        return new JavaModelStatus(964, Util.bind("classpath.mustEndWithSlash", exclusionPattern, entryPath.makeRelative().toString()));
                    }
                    if (otherKind == 3) {
                        exclusionPattern = exclusionPattern + '/';
                        return new JavaModelStatus(964, Util.bind("classpath.cannotNestEntryInEntry", new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString(), exclusionPattern}));
                    }
                    return new JavaModelStatus(964, Util.bind("classpath.cannotNestEntryInLibrary", entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString()));
                }
            }
            char[][] inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
            char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
            for (j = 0; j < outputCount; ++j) {
                currentOutput = outputLocations[j];
                if (entryPath.equals(currentOutput) || !entryPath.isPrefixOf(currentOutput) || kind == 3 && Util.isExcluded(currentOutput, inclusionPatterns, exclusionPatterns, true)) continue;
                return new JavaModelStatus(964, Util.bind("classpath.cannotNestOutputInEntry", currentOutput.makeRelative().toString(), entryPath.makeRelative().toString()));
            }
            for (j = 0; j < outputCount; ++j) {
                if (allowNestingInOutputLocations[j] || !(currentOutput = outputLocations[j]).isPrefixOf(entryPath)) continue;
                return new JavaModelStatus(964, Util.bind("classpath.cannotNestEntryInOutput", entryPath.makeRelative().toString(), currentOutput.makeRelative().toString()));
            }
        }
        for (i = 0; i < length; ++i) {
            IPath output;
            IClasspathEntry entry = classpath[i];
            if (entry == null) continue;
            IPath entryPath = entry.getPath();
            kind = entry.getEntryKind();
            isProjectRelative = entryPath.segment(0).toString().equals(projectName);
            String string = entryPathMsg = isProjectRelative ? entryPath.removeFirstSegments(1).toString() : entryPath.makeRelative().toString();
            if (kind != 3 || (output = entry.getOutputLocation()) == null) continue;
            block22: for (int j = 0; j < length; ++j) {
                IClasspathEntry otherEntry = classpath[j];
                if (otherEntry == entry) continue;
                boolean opStartsWithProject = otherEntry.getPath().segment(0).toString().equals(projectName);
                String otherPathMsg = opStartsWithProject ? otherEntry.getPath().removeFirstSegments(1).toString() : otherEntry.getPath().makeRelative().toString();
                switch (otherEntry.getEntryKind()) {
                    case 3: {
                        if (!otherEntry.getPath().equals(output)) continue block22;
                        return new JavaModelStatus(964, Util.bind("classpath.cannotUseDistinctSourceFolderAsOutput", new String[]{entryPathMsg, otherPathMsg, projectName}));
                    }
                    case 1: {
                        if (!otherEntry.getPath().equals(output)) continue block22;
                        return new JavaModelStatus(964, Util.bind("classpath.cannotUseLibraryAsOutput", new String[]{entryPathMsg, otherPathMsg, projectName}));
                    }
                }
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IJavaModelStatus validateClasspathEntry(IJavaProject project, IClasspathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = entry.getPath();
        String projectName = project.getElementName();
        boolean pathStartsWithProject = path.segment(0).toString().equals(projectName);
        String entryPathMsg = pathStartsWithProject ? path.removeFirstSegments(1).toString() : path.makeRelative().toString();
        switch (entry.getEntryKind()) {
            case 5: {
                if (path != null && path.segmentCount() >= 1) {
                    try {
                        IClasspathContainer container = JavaModelManager.getJavaModelManager().getClasspathContainer(path, project);
                        if (container == null) {
                            return new JavaModelStatus(963, (IJavaElement)project, path);
                        }
                        if (container == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                            return JavaModelStatus.VERIFIED_OK;
                        }
                        IClasspathEntry[] containerEntries = container.getClasspathEntries();
                        if (containerEntries == null) break;
                        int length = containerEntries.length;
                        for (int i = 0; i < length; ++i) {
                            IJavaModelStatus containerEntryStatus;
                            int kind;
                            IClasspathEntry containerEntry = containerEntries[i];
                            int n = kind = containerEntry == null ? 0 : containerEntry.getEntryKind();
                            if (containerEntry == null || kind == 3 || kind == 4 || kind == 5) {
                                String description = container.getDescription();
                                if (description == null) {
                                    description = path.makeRelative().toString();
                                }
                                return new JavaModelStatus(962, (IJavaElement)project, path);
                            }
                            if (!recurseInContainers || (containerEntryStatus = ClasspathEntry.validateClasspathEntry(project, containerEntry, checkSourceAttachment, recurseInContainers)).isOK()) continue;
                            return containerEntryStatus;
                        }
                        break;
                    }
                    catch (JavaModelException e) {
                        return new JavaModelStatus(e);
                    }
                }
                return new JavaModelStatus(964, Util.bind("classpath.illegalContainerPath", entryPathMsg, projectName));
            }
            case 4: {
                if (path != null && path.segmentCount() >= 1) {
                    try {
                        entry = JavaCore.getResolvedClasspathEntry(entry);
                    }
                    catch (Assert.AssertionFailedException e) {
                        return new JavaModelStatus(979, e.getMessage());
                    }
                    if (entry == null) {
                        return new JavaModelStatus(965, (IJavaElement)project, path);
                    }
                    return ClasspathEntry.validateClasspathEntry(project, entry, checkSourceAttachment, recurseInContainers);
                }
                return new JavaModelStatus(964, Util.bind("classpath.illegalVariablePath", path.makeRelative().toString(), projectName));
            }
            case 1: {
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    IPath sourceAttachment = entry.getSourceAttachmentPath();
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, path, true);
                    if (target != null && project.getOption("org.eclipse.jdt.core.incompatibleJDKLevel", true) != "ignore") {
                        long projectTargetJDK = CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                        long libraryJDK = Util.getJdkLevel(target);
                        if (libraryJDK != 0L && libraryJDK > projectTargetJDK) {
                            return new JavaModelStatus(1004, project, path, CompilerOptions.versionFromJdkLevel(libraryJDK));
                        }
                    }
                    if (target instanceof IResource) {
                        IResource resolvedResource = (IResource)target;
                        switch (resolvedResource.getType()) {
                            case 1: {
                                if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resolvedResource.getName())) {
                                    if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                                    return new JavaModelStatus(964, Util.bind("classpath.unboundSourceAttachment", new String[]{sourceAttachment.makeRelative().toString(), path.makeRelative().toString(), projectName}));
                                }
                                return new JavaModelStatus(964, Util.bind("classpath.illegalLibraryArchive", entryPathMsg, projectName));
                            }
                            case 2: {
                                if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                                return new JavaModelStatus(964, Util.bind("classpath.unboundSourceAttachment", new String[]{sourceAttachment.makeRelative().toString(), path.makeRelative().toString(), projectName}));
                            }
                        }
                        break;
                    }
                    if (target instanceof File) {
                        File file = (File)target;
                        if (!file.isFile()) {
                            return new JavaModelStatus(964, Util.bind("classpath.illegalExternalFolder", path.toOSString(), projectName));
                        }
                        if (!org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(file.getName())) {
                            return new JavaModelStatus(964, Util.bind("classpath.illegalLibraryArchive", path.toOSString(), projectName));
                        }
                        if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                        return new JavaModelStatus(964, Util.bind("classpath.unboundSourceAttachment", new String[]{sourceAttachment.toString(), path.makeRelative().toString(), projectName}));
                    }
                    return new JavaModelStatus(964, Util.bind("classpath.unboundLibrary", path.makeRelative().toString(), projectName));
                }
                return new JavaModelStatus(964, Util.bind("classpath.illegalLibraryPath", path.makeRelative().toString(), projectName));
            }
            case 2: {
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    IProject prereqProjectRsc = workspaceRoot.getProject(path.segment(0));
                    IJavaProject prereqProject = JavaCore.create(prereqProjectRsc);
                    try {
                        if (!prereqProjectRsc.exists() || !prereqProjectRsc.hasNature("org.eclipse.jdt.core.javanature")) {
                            return new JavaModelStatus(964, Util.bind("classpath.unboundProject", path.makeRelative().segment(0).toString(), projectName));
                        }
                        if (!prereqProjectRsc.isOpen()) {
                            return new JavaModelStatus(964, Util.bind("classpath.closedProject", path.segment(0).toString()));
                        }
                        if (project.getOption("org.eclipse.jdt.core.incompatibleJDKLevel", true) != "ignore") {
                            long projectTargetJDK = CompilerOptions.versionToJdkLevel(project.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                            long prereqProjectTargetJDK = CompilerOptions.versionToJdkLevel(prereqProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                            if (prereqProjectTargetJDK > projectTargetJDK) {
                                return new JavaModelStatus(1004, project, path, CompilerOptions.versionFromJdkLevel(prereqProjectTargetJDK));
                            }
                        }
                        break;
                    }
                    catch (CoreException e) {
                        return new JavaModelStatus(964, Util.bind("classpath.unboundProject", path.segment(0).toString(), projectName));
                    }
                }
                return new JavaModelStatus(964, Util.bind("classpath.illegalProjectPath", path.segment(0).toString(), projectName));
            }
            case 3: {
                if ((entry.getInclusionPatterns() != null && entry.getInclusionPatterns().length > 0 || entry.getExclusionPatterns() != null && entry.getExclusionPatterns().length > 0) && "disabled".equals(project.getOption("org.eclipse.jdt.core.classpath.exclusionPatterns", true))) {
                    return new JavaModelStatus(1002, (IJavaElement)project, path);
                }
                if (entry.getOutputLocation() != null && "disabled".equals(project.getOption("org.eclipse.jdt.core.classpath.multipleOutputLocations", true))) {
                    return new JavaModelStatus(1003, (IJavaElement)project, path);
                }
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    IPath projectPath = project.getProject().getFullPath();
                    if (projectPath.isPrefixOf(path) && JavaModel.getTarget((IContainer)workspaceRoot, path, true) != null) break;
                    return new JavaModelStatus(964, Util.bind("classpath.unboundSourceFolder", entryPathMsg, projectName));
                }
                return new JavaModelStatus(964, Util.bind("classpath.illegalSourceFolderPath", entryPathMsg, projectName));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

