/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class NameEnvironment
implements INameEnvironment,
SuffixConstants {
    boolean isIncrementalBuild = false;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    String[] initialTypeNames;
    SourceFile[] additionalUnits;

    NameEnvironment(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        this.computeClasspathLocations(root, javaProject, binaryLocationsPerProject);
        this.setNames(null, null);
    }

    public NameEnvironment(IJavaProject javaProject) {
        try {
            this.computeClasspathLocations(javaProject.getProject().getWorkspace().getRoot(), (JavaProject)javaProject, null);
        }
        catch (CoreException e) {
            this.sourceLocations = new ClasspathMultiDirectory[0];
            this.binaryLocations = new ClasspathLocation[0];
        }
        this.setNames(null, null);
    }

    private void computeClasspathLocations(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        int i;
        IMarker cycleMarker = javaProject.getCycleMarker();
        if (cycleMarker != null) {
            int severity;
            int n = severity = "error".equals(javaProject.getOption("org.eclipse.jdt.core.circularClasspath", true)) ? 2 : 1;
            if (severity != (Integer)cycleMarker.getAttribute("severity")) {
                cycleMarker.setAttribute("severity", severity);
            }
        }
        IClasspathEntry[] classpathEntries = javaProject.getExpandedClasspath(true, false, null, null);
        ArrayList<ClasspathLocation> sLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        ArrayList<ClasspathLocation> bLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        int l = classpathEntries.length;
        block5: for (int i2 = 0; i2 < l; ++i2) {
            ClasspathEntry entry = (ClasspathEntry)classpathEntries[i2];
            IPath path = entry.getPath();
            Object target = JavaModel.getTarget((IContainer)root, path, true);
            if (target == null) continue;
            switch (entry.getEntryKind()) {
                case 3: {
                    IProject outputFolder;
                    IPath outputPath;
                    if (!(target instanceof IContainer)) continue block5;
                    IPath iPath = outputPath = entry.getOutputLocation() != null ? entry.getOutputLocation() : javaProject.getOutputLocation();
                    if (outputPath.segmentCount() == 1) {
                        outputFolder = javaProject.getProject();
                    } else {
                        outputFolder = root.getFolder(outputPath);
                        if (!outputFolder.exists()) {
                            this.createFolder((IContainer)outputFolder);
                        }
                    }
                    sLocations.add(ClasspathLocation.forSourceFolder((IContainer)target, (IContainer)outputFolder, entry.fullInclusionPatternChars(), entry.fullExclusionPatternChars()));
                    continue block5;
                }
                case 2: {
                    IProject prereqProject;
                    if (!(target instanceof IProject) || !JavaProject.hasJavaNature(prereqProject = (IProject)target)) continue block5;
                    JavaProject prereqJavaProject = (JavaProject)JavaCore.create(prereqProject);
                    IClasspathEntry[] prereqClasspathEntries = prereqJavaProject.getRawClasspath();
                    ArrayList<IProject> seen = new ArrayList<IProject>();
                    int m = prereqClasspathEntries.length;
                    for (int j = 0; j < m; ++j) {
                        IProject binaryFolder;
                        Object prereqTarget;
                        IClasspathEntry prereqEntry = prereqClasspathEntries[j];
                        if (prereqEntry.getEntryKind() != 3 || !((prereqTarget = JavaModel.getTarget((IContainer)root, prereqEntry.getPath(), true)) instanceof IContainer)) continue;
                        IPath prereqOutputPath = prereqEntry.getOutputLocation() != null ? prereqEntry.getOutputLocation() : prereqJavaProject.getOutputLocation();
                        Object object = binaryFolder = prereqOutputPath.segmentCount() == 1 ? prereqProject : root.getFolder(prereqOutputPath);
                        if (!binaryFolder.exists() || seen.contains(binaryFolder)) continue;
                        seen.add(binaryFolder);
                        ClasspathLocation bLocation = ClasspathLocation.forBinaryFolder((IContainer)binaryFolder, true);
                        bLocations.add(bLocation);
                        if (binaryLocationsPerProject == null) continue;
                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(prereqProject);
                        if (existingLocations == null) {
                            existingLocations = new ClasspathLocation[]{bLocation};
                        } else {
                            int size = existingLocations.length;
                            ClasspathLocation[] classpathLocationArray = existingLocations;
                            existingLocations = new ClasspathLocation[size + 1];
                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                            existingLocations[size] = bLocation;
                        }
                        binaryLocationsPerProject.put(prereqProject, existingLocations);
                    }
                    continue block5;
                }
                case 1: {
                    if (target instanceof IResource) {
                        IResource resource = (IResource)target;
                        ClasspathLocation bLocation = null;
                        if (resource instanceof IFile) {
                            if (!Util.isArchiveFileName(path.lastSegment())) continue block5;
                            bLocation = ClasspathLocation.forLibrary((IFile)resource);
                        } else if (resource instanceof IContainer) {
                            bLocation = ClasspathLocation.forBinaryFolder((IContainer)target, false);
                        }
                        bLocations.add(bLocation);
                        if (binaryLocationsPerProject == null) continue block5;
                        IProject p = resource.getProject();
                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(p);
                        if (existingLocations == null) {
                            existingLocations = new ClasspathLocation[]{bLocation};
                        } else {
                            int size = existingLocations.length;
                            ClasspathLocation[] classpathLocationArray = existingLocations;
                            existingLocations = new ClasspathLocation[size + 1];
                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                            existingLocations[size] = bLocation;
                        }
                        binaryLocationsPerProject.put(p, existingLocations);
                        continue block5;
                    }
                    if (!(target instanceof File) || !Util.isArchiveFileName(path.lastSegment())) continue block5;
                    bLocations.add(ClasspathLocation.forLibrary(path.toString()));
                    continue block5;
                }
            }
        }
        ArrayList<ClasspathMultiDirectory> outputFolders = new ArrayList<ClasspathMultiDirectory>(1);
        this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
        if (!sLocations.isEmpty()) {
            sLocations.toArray(this.sourceLocations);
            int l2 = this.sourceLocations.length;
            block7: for (int i3 = 0; i3 < l2; ++i3) {
                int j;
                ClasspathMultiDirectory md = this.sourceLocations[i3];
                IPath outputPath = md.binaryFolder.getFullPath();
                for (j = 0; j < i3; ++j) {
                    if (!outputPath.equals(this.sourceLocations[j].binaryFolder.getFullPath())) continue;
                    md.hasIndependentOutputFolder = this.sourceLocations[j].hasIndependentOutputFolder;
                    continue block7;
                }
                outputFolders.add(md);
                int m = this.sourceLocations.length;
                for (j = 0; j < m; ++j) {
                    if (outputPath.equals(this.sourceLocations[j].sourceFolder.getFullPath())) continue block7;
                }
                md.hasIndependentOutputFolder = true;
            }
        }
        this.binaryLocations = new ClasspathLocation[outputFolders.size() + bLocations.size()];
        int index = 0;
        int l3 = outputFolders.size();
        for (i = 0; i < l3; ++i) {
            this.binaryLocations[index++] = (ClasspathLocation)outputFolders.get(i);
        }
        l3 = bLocations.size();
        for (i = 0; i < l3; ++i) {
            this.binaryLocations[index++] = (ClasspathLocation)bLocations.get(i);
        }
    }

    public void cleanup() {
        int i;
        this.initialTypeNames = null;
        this.additionalUnits = null;
        int l = this.sourceLocations.length;
        for (i = 0; i < l; ++i) {
            this.sourceLocations[i].cleanup();
        }
        l = this.binaryLocations.length;
        for (i = 0; i < l; ++i) {
            this.binaryLocations[i].cleanup();
        }
    }

    private void createFolder(IContainer folder) throws CoreException {
        if (!folder.exists()) {
            this.createFolder(folder.getParent());
            ((IFolder)folder).create(true, true, null);
        }
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String qBinaryFileName;
        if (this.initialTypeNames != null) {
            int l = this.initialTypeNames.length;
            for (int i = 0; i < l; ++i) {
                if (!qualifiedTypeName.equals(this.initialTypeNames[i])) continue;
                if (this.isIncrementalBuild) {
                    throw new AbortCompilation(true, new AbortIncrementalBuildException(qualifiedTypeName));
                }
                return null;
            }
        }
        if (this.additionalUnits != null && this.sourceLocations.length > 0) {
            Path qSourceFilePath = new Path(qualifiedTypeName + ".java");
            int qSegmentCount = qSourceFilePath.segmentCount();
            int l = this.additionalUnits.length;
            block1: for (int i = 0; i < l; ++i) {
                SourceFile additionalUnit = this.additionalUnits[i];
                IPath fullPath = additionalUnit.resource.getFullPath();
                int prefixCount = additionalUnit.sourceLocation.sourceFolder.getFullPath().segmentCount();
                if (qSegmentCount != fullPath.segmentCount() - prefixCount) continue;
                for (int j = 0; j < qSegmentCount; ++j) {
                    if (!qSourceFilePath.segment(j).equals(fullPath.segment(j + prefixCount))) continue block1;
                }
                return new NameEnvironmentAnswer(additionalUnit);
            }
        }
        String binaryFileName = qBinaryFileName = qualifiedTypeName + ".class";
        String qPackageName = "";
        if (qualifiedTypeName.length() > typeName.length) {
            int typeNameStart = qBinaryFileName.length() - typeName.length - 6;
            qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
            binaryFileName = qBinaryFileName.substring(typeNameStart);
        }
        int l = this.binaryLocations.length;
        for (int i = 0; i < l; ++i) {
            NameEnvironmentAnswer answer = this.binaryLocations[i].findClass(binaryFileName, qPackageName, qBinaryFileName);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.isPackage(new String(CharOperation.concatWith(compoundName, packageName, '/')));
    }

    public boolean isPackage(String qualifiedPackageName) {
        int l = this.binaryLocations.length;
        for (int i = 0; i < l; ++i) {
            if (!this.binaryLocations[i].isPackage(qualifiedPackageName)) continue;
            return true;
        }
        return false;
    }

    void setNames(String[] initialTypeNames, SourceFile[] additionalUnits) {
        int i;
        this.initialTypeNames = initialTypeNames;
        this.additionalUnits = additionalUnits;
        int l = this.sourceLocations.length;
        for (i = 0; i < l; ++i) {
            this.sourceLocations[i].reset();
        }
        l = this.binaryLocations.length;
        for (i = 0; i < l; ++i) {
            this.binaryLocations[i].reset();
        }
    }
}

