/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.IOException;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.util.SimpleSet;

public class EntryResult {
    private char[] word;
    private HashtableOfObject[] documentTables;
    private SimpleSet documentNames;

    public EntryResult(char[] word, HashtableOfObject table) {
        this.word = word;
        if (table != null) {
            this.documentTables = new HashtableOfObject[]{table};
        }
    }

    public void addDocumentName(String documentName) {
        if (this.documentNames == null) {
            this.documentNames = new SimpleSet(3);
        }
        this.documentNames.add(documentName);
    }

    public void addDocumentTable(HashtableOfObject table) {
        if (this.documentTables == null) {
            this.documentTables = new HashtableOfObject[]{table};
            return;
        }
        int length = this.documentTables.length;
        this.documentTables = new HashtableOfObject[length + 1];
        System.arraycopy(this.documentTables, 0, this.documentTables, 0, length);
        this.documentTables[length] = table;
    }

    public char[] getWord() {
        return this.word;
    }

    public String[] getDocumentNames(Index index) throws IOException {
        if (this.documentTables != null) {
            int l = this.documentTables.length;
            for (int i = 0; i < l; ++i) {
                Object offset = this.documentTables[i].get(this.word);
                int[] numbers = index.diskIndex.readDocumentNumbers(offset);
                int k = numbers.length;
                for (int j = 0; j < k; ++j) {
                    this.addDocumentName(index.diskIndex.readDocumentName(numbers[j]));
                }
            }
        }
        if (this.documentNames == null) {
            return new String[0];
        }
        String[] names = new String[this.documentNames.elementSize];
        int count = 0;
        Object[] values = this.documentNames.values;
        int l = values.length;
        for (int i = 0; i < l; ++i) {
            if (values[i] == null) continue;
            names[count++] = (String)values[i];
        }
        return names;
    }

    public boolean isEmpty() {
        return this.documentTables == null && this.documentNames == null;
    }
}

