/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.Locale;
import org.eclipse.ant.internal.ui.editor.text.IAntEditorColorConstants;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.ColorManager;
import org.eclipse.ant.internal.ui.preferences.AntEditorPreferenceConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AntUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 120;
    private static AntUIPlugin plugin;
    public static final String PI_ANTUI = "org.eclipse.ant.ui";
    private static final String EMPTY_STRING = "";

    public AntUIPlugin() {
        plugin = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            AntUIImages.disposeImageDescriptorRegistry();
        }
        finally {
            super.stop(context);
        }
    }

    public static AntUIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PI_ANTUI;
    }

    public static void log(Throwable t) {
        Status status = new Status(4, PI_ANTUI, 120, "Error logged from Ant UI: ", t);
        AntUIPlugin.log((IStatus)status);
    }

    public static void log(IStatus status) {
        AntUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = AntUIPlugin.newErrorStatus(message, exception);
        AntUIPlugin.log(status);
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = EMPTY_STRING;
        }
        return new Status(4, PI_ANTUI, 0, message, exception);
    }

    protected void initializeDefaultPreferences(IPreferenceStore prefs) {
        prefs.setDefault("ant.findBuildFileNames", "build.xml");
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)prefs);
        EditorsUI.useQuickDiffPreferencePage((IPreferenceStore)prefs);
        if (AntUIPlugin.isMacOS()) {
            prefs.setDefault("toolsJAR", false);
        } else {
            prefs.setDefault("toolsJAR", true);
        }
        prefs.setDefault("errorDialog", true);
        prefs.setDefault("anteditor.filterInternalTargets", false);
        prefs.setDefault("anteditor.filterImportedElements", false);
        prefs.setDefault("anteditor.filterProperties", false);
        prefs.setDefault("anteditor.filterTopLevel", false);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.textColor", (RGB)IAntEditorColorConstants.DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.processingInstructionsColor", (RGB)IAntEditorColorConstants.PROC_INSTR);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.constantStringsColor", (RGB)IAntEditorColorConstants.STRING);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.tagsColor", (RGB)IAntEditorColorConstants.TAG);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.commentsColor", (RGB)IAntEditorColorConstants.XML_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.errorColor", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.warningColor", (RGB)new RGB(250, 100, 0));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.informationColor", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.verboseColor", (RGB)new RGB(0, 200, 125));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.ant.ui.debugColor", (RGB)new RGB(0, 0, 0));
        AntEditorPreferenceConstants.initializeDefaultValues(prefs);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected ImageRegistry createImageRegistry() {
        return AntUIImages.initializeImageRegistry();
    }

    public static Color getPreferenceColor(String pref) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)AntUIPlugin.getDefault().getPreferenceStore(), (String)pref));
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = AntUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return AntUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static boolean isMacOS() {
        String osname = System.getProperty("os.name").toLowerCase(Locale.US);
        return osname.indexOf("mac") != -1;
    }
}

