/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.dialogs.SimpleListContentProvider;

public class FeatureSelectionDialog
extends SelectionDialog {
    private static final int LIST_WIDTH = 60;
    private static final int LIST_HEIGHT = 10;
    private AboutInfo[] features;
    private ListViewer listViewer;
    private String helpContextId;

    public FeatureSelectionDialog(Shell shell, AboutInfo[] features, String primaryFeatureId, String shellTitle, String shellMessage, String helpContextId) {
        super(shell);
        if (features == null || features.length == 0) {
            throw new IllegalArgumentException();
        }
        this.features = features;
        this.helpContextId = helpContextId;
        this.setTitle(shellTitle);
        this.setMessage(shellMessage);
        Arrays.sort(features, new Comparator(){
            Collator coll = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                AboutInfo i1 = (AboutInfo)a;
                String name1 = i1.getFeatureLabel();
                AboutInfo i2 = (AboutInfo)b;
                String name2 = i2.getFeatureLabel();
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                return this.coll.compare(name1, name2);
            }
        });
        for (int i = 0; i < features.length; ++i) {
            if (!features[i].getFeatureId().equals(primaryFeatureId)) continue;
            this.setInitialSelections(new Object[]{features[i]});
            return;
        }
        this.setInitialSelections(new Object[0]);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)this.helpContextId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.listViewer = new ListViewer(composite, 2820);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        this.listViewer.getList().setLayoutData((Object)data);
        this.listViewer.getList().setFont(parent.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? "" : ((AboutInfo)element).getFeatureLabel();
            }
        });
        SimpleListContentProvider cp = new SimpleListContentProvider();
        cp.setElements(this.features);
        this.listViewer.setContentProvider((IContentProvider)cp);
        this.listViewer.setInput(new Object());
        this.listViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FeatureSelectionDialog.this.getOkButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FeatureSelectionDialog.this.okPressed();
            }
        });
        return composite;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }
}

