/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.security;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.BannerPage;

public class JarVerificationPage
extends BannerPage {
    private IVerificationResult _VerificationResult = null;
    private String _fileName = null;
    private String _strFeatureName = null;
    private String _strId = null;
    private String _strProviderName = null;
    private TitleAreaDialog _Dialog;
    private String componentVerified;

    public JarVerificationPage(IVerificationResult verificationResult) {
        super(UpdateUI.getString("JarVerificationDialog.Verification"));
        this._fileName = verificationResult.getContentReference().getIdentifier();
        this._VerificationResult = verificationResult;
        this._strId = verificationResult.getFeature().getVersionedIdentifier().toString();
        this._strFeatureName = verificationResult.getFeature().getLabel();
        this._strProviderName = verificationResult.getFeature().getProvider();
        this.componentVerified = verificationResult.isFeatureVerification() ? ".Feature" : ".File";
    }

    protected Control createContents(Composite compositeParent) {
        WorkbenchHelp.setHelp((Control)compositeParent, (String)"org.eclipse.update.ui.JarVerificationPage");
        Composite compositeClient = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compositeClient.setLayout((Layout)layout);
        compositeClient.setLayoutData((Object)new GridData(1808));
        this.createTextArea(compositeClient);
        this.createCertificateArea(compositeClient);
        this.createInformationArea(compositeClient);
        Dialog.applyDialogFont((Control)compositeParent);
        return compositeClient;
    }

    private void createTextArea(Composite compositeClient) {
        Label labelInformation = new Label(compositeClient, 64);
        labelInformation.setLayoutData((Object)new GridData(770));
        StringBuffer strb = new StringBuffer();
        switch (this._VerificationResult.getVerificationCode()) {
            case 1: {
                String msg = UpdateUI.getString("JarVerificationDialog.AboutToInstall" + this.componentVerified);
                this.setMessage(msg, 2);
                strb.append(UpdateUI.getString("JarVerificationDialog.NotDigitallySigned" + this.componentVerified));
                strb.append("\r\n");
                strb.append(UpdateUI.getString("JarVerificationDialog.CannotVerifyProvider" + this.componentVerified));
                labelInformation.setText(strb.toString());
                break;
            }
            case 2: {
                String msg = UpdateUI.getString("JarVerificationDialog.CorruptedContent" + this.componentVerified);
                this.setMessage(msg, 3);
                strb.append(UpdateUI.getString("JarVerificationDialog.ComponentNotInstalled"));
                labelInformation.setText(strb.toString());
                break;
            }
            case 5: {
                String msg = UpdateUI.getString("JarVerificationDialog.SignedComponent" + this.componentVerified);
                this.setMessage(msg, 2);
                strb.append(UpdateUI.getString("JarVerificationDialog.UnknownCertificate" + this.componentVerified));
                strb.append("\r\n");
                strb.append(UpdateUI.getString("JarVerificationDialog.UnableToVerifyProvider" + this.componentVerified));
                labelInformation.setText(strb.toString());
                break;
            }
            case 3: {
                String msg = UpdateUI.getString("JarVerificationDialog.SignedComponent" + this.componentVerified);
                this.setMessage(msg, 2);
                strb.append(UpdateUI.getString("JarVerificationDialog.KnownCertificate" + this.componentVerified));
                strb.append("\r\n");
                strb.append(UpdateUI.getString("JarVerificationDialog.ProviderKnown" + this.componentVerified));
                strb.append("\r\n");
                labelInformation.setText(strb.toString());
            }
        }
    }

    private void createInformationArea(Composite compositeClient) {
        Composite compositeInformation = new Composite(compositeClient, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compositeInformation.setLayout((Layout)layout);
        compositeInformation.setLayoutData((Object)new GridData(768));
        Label keyLabel = null;
        CLabel valueLabel = null;
        if (this._strFeatureName != null && this._strFeatureName.length() > 0) {
            keyLabel = new Label(compositeInformation, 0);
            keyLabel.setText(UpdateUI.getString("JarVerificationDialog.FeatureName"));
            valueLabel = new CLabel(compositeInformation, 0);
            valueLabel.setFont(JFaceResources.getBannerFont());
            valueLabel.setText(this._strFeatureName);
            valueLabel.setLayoutData((Object)new GridData(768));
        }
        if (this._strId != null && this._strId.length() > 0) {
            keyLabel = new Label(compositeInformation, 0);
            keyLabel.setText(UpdateUI.getString("JarVerificationDialog.FeatureIdentifier"));
            valueLabel = new CLabel(compositeInformation, 0);
            valueLabel.setFont(JFaceResources.getBannerFont());
            valueLabel.setText(this._strId);
            valueLabel.setLayoutData((Object)new GridData(768));
        }
        if (this._strProviderName != null && this._strProviderName.length() > 0) {
            keyLabel = new Label(compositeInformation, 0);
            keyLabel.setText(UpdateUI.getString("JarVerificationDialog.Provider"));
            valueLabel = new CLabel(compositeInformation, 0);
            valueLabel.setFont(JFaceResources.getBannerFont());
            valueLabel.setText(this._strProviderName);
            valueLabel.setLayoutData((Object)new GridData(768));
        }
        keyLabel = new Label(compositeInformation, 0);
        keyLabel.setText(UpdateUI.getString("JarVerificationDialog.FileName"));
        valueLabel = new CLabel(compositeInformation, 0);
        valueLabel.setFont(JFaceResources.getBannerFont());
        valueLabel.setText(this._fileName);
        valueLabel.setLayoutData((Object)new GridData(768));
    }

    private void createCertificateArea(Composite compositeClient) {
        if (this._VerificationResult.getVerificationCode() == 5 || this._VerificationResult.getVerificationCode() == 3) {
            Group group = new Group(compositeClient, 16);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            group.setText(UpdateUI.getString("JarVerificationDialog.CertificateInfo"));
            Label keyLabel = null;
            Text valueText = null;
            if (this._VerificationResult.getSignerInfo() != null) {
                keyLabel = new Label((Composite)group, 0);
                keyLabel.setText(UpdateUI.getString("JarVerificationDialog.SubjectCA"));
                keyLabel.setLayoutData((Object)new GridData(2));
                valueText = new Text((Composite)group, 2626);
                valueText.setText(this._VerificationResult.getSignerInfo());
                valueText.setEditable(false);
                valueText.setLayoutData((Object)new GridData(768));
            }
            if (this._VerificationResult.getVerifierInfo() != null) {
                keyLabel = new Label((Composite)group, 0);
                keyLabel.setText(UpdateUI.getString("JarVerificationDialog.RootCA"));
                keyLabel.setLayoutData((Object)new GridData(2));
                valueText = new Text((Composite)group, 2626);
                valueText.setText(this._VerificationResult.getVerifierInfo());
                valueText.setEditable(false);
                valueText.setLayoutData((Object)new GridData(768));
            }
        }
    }

    public void setTitleAreaDialog(TitleAreaDialog dialog) {
        this._Dialog = dialog;
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        if (this._Dialog != null) {
            this._Dialog.setMessage(newMessage, newType);
        }
    }
}

