/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.LicensePage;
import org.eclipse.update.internal.ui.wizards.ModeSelectionPage;
import org.eclipse.update.internal.ui.wizards.OptionalFeaturesPage;
import org.eclipse.update.internal.ui.wizards.ReviewPage;
import org.eclipse.update.internal.ui.wizards.SearchRunner;
import org.eclipse.update.internal.ui.wizards.SitePage;
import org.eclipse.update.internal.ui.wizards.TargetPage;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.UpdateSearchRequest;

public class InstallWizard
extends Wizard
implements IOperationListener,
ISearchProvider {
    private ModeSelectionPage modePage;
    private SitePage sitePage;
    private ReviewPage reviewPage;
    private LicensePage licensePage;
    private OptionalFeaturesPage optionalFeaturesPage;
    private TargetPage targetPage;
    private IInstallConfiguration config;
    private int installCount = 0;
    private SearchRunner searchRunner;
    private UpdateSearchRequest searchRequest;
    private ArrayList jobs;
    private boolean needsRestart;
    private static boolean isRunning;

    public InstallWizard() {
        this(null);
    }

    public InstallWizard(UpdateSearchRequest searchRequest) {
        isRunning = true;
        this.searchRequest = searchRequest;
        this.setDialogSettings(UpdateUI.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(UpdateUIImages.DESC_UPDATE_WIZ);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(UpdateUI.getString("InstallWizard.wtitle"));
    }

    public InstallWizard(UpdateSearchRequest searchRequest, ArrayList jobs) {
        this(searchRequest);
        this.jobs = jobs;
    }

    public int getInstallCount() {
        return this.installCount;
    }

    public boolean isRestartNeeded() {
        return this.installCount > 0 && this.needsRestart;
    }

    public boolean performCancel() {
        isRunning = false;
        if (this.targetPage != null) {
            this.targetPage.removeAddedSites();
        }
        return super.performCancel();
    }

    /*
     * Exception decompiling
     */
    public boolean performFinish() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addPages() {
        this.searchRunner = new SearchRunner(this.getShell(), (IRunnableContext)this.getContainer());
        if (this.searchRequest == null && this.jobs == null) {
            this.modePage = new ModeSelectionPage(this.searchRunner);
            this.addPage((IWizardPage)this.modePage);
            this.sitePage = new SitePage(this.searchRunner);
            this.addPage((IWizardPage)this.sitePage);
        } else {
            this.searchRunner.setSearchProvider(this);
            if (this.jobs != null) {
                this.searchRunner.setNewSearchNeeded(false);
            }
        }
        this.reviewPage = new ReviewPage(this.searchRunner, this.jobs);
        this.searchRunner.setResultCollector(this.reviewPage);
        this.addPage((IWizardPage)this.reviewPage);
        try {
            this.config = SiteManager.getLocalSite().getCurrentConfiguration();
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        this.licensePage = new LicensePage(true);
        this.addPage((IWizardPage)this.licensePage);
        this.optionalFeaturesPage = new OptionalFeaturesPage(this.config);
        this.addPage((IWizardPage)this.optionalFeaturesPage);
        this.targetPage = new TargetPage(this.config);
        this.addPage((IWizardPage)this.targetPage);
    }

    private void saveSettings() {
        if (this.modePage != null) {
            this.modePage.saveSettings();
        }
    }

    private boolean isPageRequired(IWizardPage page) {
        if (page == null) {
            return false;
        }
        if (page.equals(this.licensePage)) {
            return OperationsManager.hasSelectedJobsWithLicenses((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.optionalFeaturesPage)) {
            return OperationsManager.hasSelectedJobsWithOptionalFeatures((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.targetPage)) {
            return this.reviewPage.getSelectedJobs().length > 0;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        boolean start = false;
        IWizardPage nextPage = null;
        if (this.modePage != null && page.equals(this.modePage)) {
            boolean update = this.modePage.isUpdateMode();
            if (update) {
                return this.reviewPage;
            }
            return this.sitePage;
        }
        if (this.sitePage != null && page.equals(this.sitePage)) {
            return this.reviewPage;
        }
        if (page.equals((Object)this.reviewPage)) {
            this.updateDynamicPages();
        }
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i].equals(page)) {
                start = true;
                continue;
            }
            if (!start || !this.isPageRequired(pages[i])) continue;
            nextPage = pages[i];
            break;
        }
        return nextPage;
    }

    private void updateDynamicPages() {
        if (this.licensePage != null) {
            IInstallFeatureOperation[] licenseJobs = OperationsManager.getSelectedJobsWithLicenses((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
            this.licensePage.setJobs(licenseJobs);
        }
        if (this.optionalFeaturesPage != null) {
            IInstallFeatureOperation[] optionalJobs = OperationsManager.getSelectedJobsWithOptionalFeatures((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
            this.optionalFeaturesPage.setJobs(optionalJobs);
        }
        if (this.targetPage != null) {
            IInstallFeatureOperation[] installJobs = this.reviewPage.getSelectedJobs();
            this.targetPage.setJobs(installJobs);
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page.equals(this.targetPage) && page.isPageComplete();
    }

    private void preserveOriginatingURLs(IFeature feature, IFeatureReference[] optionalFeatures) {
        URL url = feature.getSite().getURL();
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            for (int i = 0; i < irefs.length; ++i) {
                IIncludedFeatureReference iref = irefs[i];
                boolean preserve = false;
                if (iref.isOptional()) {
                    boolean onTheList = false;
                    for (int j = 0; j < optionalFeatures.length; ++j) {
                        if (!optionalFeatures[j].equals(iref)) continue;
                        onTheList = true;
                        break;
                    }
                    if (!onTheList) {
                        preserve = true;
                    }
                }
                if (preserve) {
                    try {
                        String id = iref.getVersionedIdentifier().getIdentifier();
                        UpdateUI.setOriginatingURL(id, url);
                    }
                    catch (CoreException e) {}
                    continue;
                }
                try {
                    IFeature ifeature = iref.getFeature(null);
                    this.preserveOriginatingURLs(ifeature, optionalFeatures);
                    continue;
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    public boolean afterExecute(IOperation operation, Object data) {
        if (!(operation instanceof IInstallFeatureOperation)) {
            return true;
        }
        IInstallFeatureOperation job = (IInstallFeatureOperation)operation;
        IFeature oldFeature = job.getOldFeature();
        if (oldFeature == null && job.getOptionalFeatures() != null) {
            this.preserveOriginatingURLs(job.getFeature(), job.getOptionalFeatures());
        }
        ++this.installCount;
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public static synchronized boolean isRunning() {
        return isRunning;
    }
}

