/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;

class ReferenceAnalyzer
extends MoveStaticMemberAnalyzer {
    public ReferenceAnalyzer(CompilationUnitRewrite cuRewrite, IBinding[] members, ITypeBinding target, ITypeBinding source) {
        super(cuRewrite, members, source, target);
    }

    public boolean needsTargetImport() {
        return this.fNeedsImport;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        VariableDeclarationFragment singleFragment = (VariableDeclarationFragment)node.fragments().get(0);
        if (this.isMovedMember((IBinding)singleFragment.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(SimpleName node) {
        if (!node.isDeclaration() && this.isMovedMember(node.resolveBinding()) && !this.isProcessed((ASTNode)node)) {
            this.rewrite(node, this.fTarget);
        }
        return false;
    }

    public boolean visit(QualifiedName node) {
        if (this.isMovedMember(node.resolveBinding())) {
            if (node.getParent() instanceof ImportDeclaration) {
                this.fCuRewrite.getImportRewrite().removeImport(node.resolveTypeBinding());
                this.fCuRewrite.getImportRewrite().addImport(this.fTarget.getQualifiedName() + '.' + node.getName().getIdentifier());
            } else {
                this.rewrite(node, this.fTarget);
            }
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(FieldAccess node) {
        if (this.isMovedMember((IBinding)node.resolveFieldBinding())) {
            this.rewrite(node, this.fTarget);
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        if (this.isMovedMember((IBinding)node.resolveMethodBinding())) {
            this.rewrite(node, this.fTarget);
        }
        return super.visit(node);
    }

    public boolean visit(MemberRef node) {
        if (this.isMovedMember(node.resolveBinding())) {
            this.rewrite(node, this.fTarget);
        }
        return false;
    }

    public boolean visit(MethodRef node) {
        if (this.isMovedMember(node.resolveBinding())) {
            this.rewrite(node, this.fTarget);
        }
        return false;
    }
}

