/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.ListDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.ExternalizeStringsAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class FindStringsToExternalizeAction
extends SelectionDispatchAction {
    private NonNLSElement[] fElements;

    public FindStringsToExternalizeAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("FindStringsToExternalizeAction.label"));
        this.fElements = new NonNLSElement[0];
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.find_strings_to_externalize_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.computeEnablementState(selection));
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            this.setEnabled(false);
        }
    }

    private boolean computeEnablementState(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IPackageFragmentRoot root;
            Object element = iter.next();
            if (!(element instanceof IJavaElement)) {
                return false;
            }
            IJavaElement javaElement = (IJavaElement)element;
            if (!javaElement.exists() || javaElement.isReadOnly()) {
                return false;
            }
            int elementType = javaElement.getElementType();
            if (elementType != 4 && elementType != 3 && elementType != 2) {
                return false;
            }
            if (elementType != 3 || !(root = (IPackageFragmentRoot)javaElement).isExternal() && !ReorgUtils.isClassFolder((IJavaElement)root)) continue;
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection selection) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, this.createRunnable(selection));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("FindStringsToExternalizeAction.dialog.title"), ActionMessages.getString("FindStringsToExternalizeAction.error.message"));
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        this.showResults();
    }

    private IRunnableWithProgress createRunnable(final IStructuredSelection selection) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                FindStringsToExternalizeAction.access$002(FindStringsToExternalizeAction.this, FindStringsToExternalizeAction.this.doRun(selection, pm));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NonNLSElement[] doRun(IStructuredSelection selection, IProgressMonitor pm) {
        List elements = FindStringsToExternalizeAction.getSelectedElementList(selection);
        if (elements == null || elements.isEmpty()) {
            return new NonNLSElement[0];
        }
        pm.beginTask(ActionMessages.getString("FindStringsToExternalizeAction.find_strings"), elements.size());
        try {
            ArrayList l = new ArrayList();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                if (element.getElementType() == 4) {
                    l.addAll(this.analyze((IPackageFragment)element, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else if (element.getElementType() == 3) {
                    l.addAll(this.analyze((IPackageFragmentRoot)element, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                }
                if (element.getElementType() != 2) continue;
                l.addAll(this.analyze((IJavaProject)element, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
            NonNLSElement[] nonNLSElementArray = l.toArray(new NonNLSElement[l.size()]);
            return nonNLSElementArray;
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getDialogTitle(), ActionMessages.getString("FindStringsToExternalizeAction.error.message"));
            NonNLSElement[] nonNLSElementArray = new NonNLSElement[]{};
            return nonNLSElementArray;
        }
        finally {
            pm.done();
        }
    }

    private void showResults() {
        if (this.noStrings()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString("FindStringsToExternalizeAction.noStrings"));
        } else {
            new NonNLSListDialog(this.getShell(), this.fElements, this.countStrings()).open();
        }
    }

    private boolean noStrings() {
        for (int i = 0; i < this.fElements.length; ++i) {
            if (this.fElements[i].count == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List analyze(IPackageFragment pack, IProgressMonitor pm) throws JavaModelException {
        try {
            if (pack == null) {
                ArrayList arrayList = new ArrayList(0);
                return arrayList;
            }
            ICompilationUnit[] cus = pack.getCompilationUnits();
            pm.beginTask("", cus.length);
            pm.setTaskName(pack.getElementName());
            ArrayList<NonNLSElement> l = new ArrayList<NonNLSElement>(cus.length);
            for (int i = 0; i < cus.length; ++i) {
                pm.subTask(cus[i].getElementName());
                NonNLSElement element = this.analyze(cus[i]);
                if (element != null) {
                    l.add(element);
                }
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            ArrayList<NonNLSElement> arrayList = l;
            return arrayList;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List analyze(IPackageFragmentRoot sourceFolder, IProgressMonitor pm) throws JavaModelException {
        try {
            IJavaElement[] children = sourceFolder.getChildren();
            pm.beginTask("", children.length);
            pm.setTaskName(sourceFolder.getElementName());
            ArrayList result = new ArrayList();
            for (int i = 0; i < children.length; ++i) {
                IJavaElement iJavaElement = children[i];
                if (iJavaElement.getElementType() == 4) {
                    IPackageFragment pack = (IPackageFragment)iJavaElement;
                    if (!pack.isReadOnly()) {
                        result.addAll(this.analyze(pack, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        continue;
                    }
                    pm.worked(1);
                    continue;
                }
                pm.worked(1);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List analyze(IJavaProject project, IProgressMonitor pm) throws JavaModelException {
        try {
            IPackageFragment[] packs = project.getPackageFragments();
            pm.beginTask("", packs.length);
            ArrayList result = new ArrayList();
            for (int i = 0; i < packs.length; ++i) {
                if (!packs[i].isReadOnly()) {
                    result.addAll(this.analyze(packs[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    continue;
                }
                pm.worked(1);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            pm.done();
        }
    }

    private int countStrings() {
        int found = 0;
        for (int i = 0; i < this.fElements.length; ++i) {
            found += this.fElements[i].count;
        }
        return found;
    }

    private NonNLSElement analyze(ICompilationUnit cu) {
        int count = this.countNonExternalizedStrings(cu);
        if (count == 0) {
            return null;
        }
        return new NonNLSElement(cu, count);
    }

    private int countNonExternalizedStrings(ICompilationUnit cu) {
        try {
            NLSLine[] lines = NLSScanner.scan(cu);
            int result = 0;
            for (int i = 0; i < lines.length; ++i) {
                result += this.countNonExternalizedStrings(lines[i]);
            }
            return result;
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getDialogTitle(), ActionMessages.getString("FindStringsToExternalizeAction.error.message"));
            return 0;
        }
        catch (InvalidInputException iie) {
            JavaPlugin.log(iie);
            return 0;
        }
    }

    private int countNonExternalizedStrings(NLSLine line) {
        int result = 0;
        NLSElement[] elements = line.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].hasTag()) continue;
            ++result;
        }
        return result;
    }

    private static List getSelectedElementList(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        return selection.toList();
    }

    private String getDialogTitle() {
        return ActionMessages.getString("FindStringsToExternalizeAction.dialog.title");
    }

    static /* synthetic */ NonNLSElement[] access$002(FindStringsToExternalizeAction x0, NonNLSElement[] x1) {
        x0.fElements = x1;
        return x1;
    }

    private static class NonNLSElement {
        ICompilationUnit cu;
        int count;

        NonNLSElement(ICompilationUnit cu, int count) {
            this.cu = cu;
            this.count = count;
        }
    }

    private static class NonNLSListDialog
    extends ListDialog {
        private static final int OPEN_BUTTON_ID = 1025;
        private Button fOpenButton;

        NonNLSListDialog(Shell parent, NonNLSElement[] input, int count) {
            super(parent);
            this.setInput(Arrays.asList(input));
            this.setTitle(ActionMessages.getString("FindStringsToExternalizeAction.dialog.title"));
            this.setMessage(ActionMessages.getFormattedString("FindStringsToExternalizeAction.non_externalized", new Object[]{new Integer(count)}));
            this.setContentProvider(new ListContentProvider());
            this.setLabelProvider((ILabelProvider)NonNLSListDialog.createLabelProvider());
        }

        public void create() {
            this.setShellStyle(2288);
            super.create();
        }

        protected Point getInitialSize() {
            return this.getShell().computeSize(-1, -1, true);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(this){
                private final /* synthetic */ NonNLSListDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    if (NonNLSListDialog.access$200(this.this$0) != null) {
                        NonNLSListDialog.access$200(this.this$0).setEnabled(!this.this$0.getTableViewer().getSelection().isEmpty());
                    }
                }
            });
            this.getTableViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ NonNLSListDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    NonNLSElement element = (NonNLSElement)e.item.getData();
                    NonNLSListDialog.access$300(this.this$0, element.cu);
                }
            });
            this.getTableViewer().getTable().setFocus();
            NonNLSListDialog.applyDialogFont((Control)result);
            return result;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fOpenButton = this.createButton(parent, 1025, ActionMessages.getString("FindStringsToExternalizeAction.button.label"), true);
            this.fOpenButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            IStructuredSelection ss;
            if (buttonId != 1025) {
                super.buttonPressed(buttonId);
                return;
            }
            ISelection s = this.getTableViewer().getSelection();
            if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).getFirstElement() instanceof NonNLSElement) {
                this.openWizard(((NonNLSElement)ss.getFirstElement()).cu);
            }
        }

        private void openWizard(ICompilationUnit unit) {
            try {
                ExternalizeStringsAction.openExternalizeStringsWizard(this.getShell(), unit);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), ActionMessages.getString("FindStringsToExternalizeAction.dialog.title"), ActionMessages.getString("FindStringsToExternalizeAction.error.message"));
            }
        }

        private static LabelProvider createLabelProvider() {
            return new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT){

                public String getText(Object element) {
                    NonNLSElement nlsel = (NonNLSElement)element;
                    String elementName = ResourceUtil.getResource(nlsel.cu).getFullPath().toString();
                    return ActionMessages.getFormattedString("FindStringsToExternalizeAction.foundStrings", new Object[]{new Integer(nlsel.count), elementName});
                }

                public Image getImage(Object element) {
                    return super.getImage(((NonNLSElement)element).cu);
                }
            };
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.nonnls_dialog_context");
        }

        static /* synthetic */ Button access$200(NonNLSListDialog x0) {
            return x0.fOpenButton;
        }

        static /* synthetic */ void access$300(NonNLSListDialog x0, ICompilationUnit x1) {
            x0.openWizard(x1);
        }
    }
}

