/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.internal.dm;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int iM;
    private BitmapDescriptor qn;
    private LatLng qo;
    private float qp;
    private float qq;
    private LatLngBounds qr;
    private float qd;
    private float qk;
    private boolean ql = true;
    private float qs = 0.0f;
    private float qt = 0.5f;
    private float qu = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.iM = versionCode;
        this.qn = new BitmapDescriptor(b.a.z(wrappedImage));
        this.qo = location;
        this.qp = width;
        this.qq = height;
        this.qr = bounds;
        this.qd = bearing;
        this.qk = zIndex;
        this.ql = visible;
        this.qs = transparency;
        this.qt = anchorU;
        this.qu = anchorV;
    }

    public GroundOverlayOptions() {
        this.iM = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.cK()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder cM() {
        return this.qn.cs().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.qn = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.qt = u2;
        this.qu = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        dm.a(this.qr == null, (Object)"Position has already been set using positionFromBounds");
        dm.b(location != null, "Location must be specified");
        dm.b(width >= 0.0f, "Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        dm.a(this.qr == null, (Object)"Position has already been set using positionFromBounds");
        dm.b(location != null, "Location must be specified");
        dm.b(width >= 0.0f, "Width must be non-negative");
        dm.b(height >= 0.0f, "Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.qo = latLng;
        this.qp = f2;
        this.qq = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        dm.a(this.qo == null, (Object)("Position has already been set using position: " + this.qo));
        this.qr = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.qd = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.qk = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.ql = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        dm.b(transparency >= 0.0f && transparency <= 1.0f, "Transparency must be in the range [0..1]");
        this.qs = transparency;
        return this;
    }

    int getVersionCode() {
        return this.iM;
    }

    public BitmapDescriptor getImage() {
        return this.qn;
    }

    public LatLng getLocation() {
        return this.qo;
    }

    public float getWidth() {
        return this.qp;
    }

    public float getHeight() {
        return this.qq;
    }

    public LatLngBounds getBounds() {
        return this.qr;
    }

    public float getBearing() {
        return this.qd;
    }

    public float getZIndex() {
        return this.qk;
    }

    public float getTransparency() {
        return this.qs;
    }

    public float getAnchorU() {
        return this.qt;
    }

    public float getAnchorV() {
        return this.qu;
    }

    public boolean isVisible() {
        return this.ql;
    }
}

