/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.PixelConverter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LaunchConfigurationPropertiesDialog
extends LaunchConfigurationsDialog
implements ILaunchConfigurationListener {
    private ILaunchConfiguration fLaunchConfiguration;

    public LaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration launchConfiguration, LaunchGroupExtension group) {
        super(shell, group);
        this.setLaunchConfiguration(launchConfiguration);
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    private void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fLaunchConfiguration = configuration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void initializeContent() {
        this.getTabViewer().setInput(this.getLaunchConfiguration());
        IStatus status = this.getInitialStatus();
        if (status != null) {
            this.handleStatus(status);
        }
    }

    public boolean close() {
        this.persistShellGeometry();
        this.getBannerImage().dispose();
        this.getTabViewer().dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        return super.close();
    }

    protected void addContent(Composite dialogComp) {
        Composite topComp = new Composite(dialogComp, 0);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 0;
        topComp.setLayout((Layout)topLayout);
        topComp.setFont(dialogComp.getFont());
        this.setTitle(this.getTitleAreaTitle());
        this.setMessage("");
        this.setModeLabelState();
        Composite editAreaComp = this.createLaunchConfigurationEditArea(topComp);
        this.setEditArea(editAreaComp);
        gd = new GridData(1808);
        editAreaComp.setLayoutData((Object)gd);
        editAreaComp.setFont(dialogComp.getFont());
        Label separator = new Label(topComp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
        dialogComp.layout(true);
        LaunchConfigurationPropertiesDialog.applyDialogFont((Control)dialogComp);
    }

    protected String getTitleAreaTitle() {
        return LaunchConfigurationsMessages.getString("LaunchConfigurationPropertiesDialog.Edit_launch_configuration_properties_1");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected String getShellTitle() {
        return MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationPropertiesDialog.Properties_for_{0}_2"), this.getLaunchConfiguration().getName());
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.LAUNCH_CONFIGURATION_PROPERTIES_DIALOG;
    }

    protected void resize() {
        PixelConverter pixelConverter = new PixelConverter((Control)this.getEditArea());
        int runningTabWidth = 0;
        ILaunchConfigurationTabGroup group = this.getTabGroup();
        if (group == null) {
            return;
        }
        ILaunchConfigurationTab[] tabs = group.getTabs();
        Point contentSize = new Point(0, 0);
        for (int i = 0; i < tabs.length; ++i) {
            Control control;
            String name = tabs[i].getName();
            Image image = tabs[i].getImage();
            runningTabWidth += pixelConverter.convertWidthInCharsToPixels(name.length() + 5);
            if (image != null) {
                runningTabWidth += image.getBounds().width;
            }
            if ((control = tabs[i].getControl()) == null) continue;
            Point size = control.computeSize(-1, -1, true);
            if (size.x > contentSize.x) {
                contentSize.x = size.x;
            }
            if (size.y <= contentSize.y) continue;
            contentSize.y = size.y;
        }
        if (runningTabWidth > contentSize.x) {
            int maxAllowedWidth = (int)((float)this.getDisplay().getBounds().width * 0.5f);
            contentSize.x = runningTabWidth > maxAllowedWidth ? maxAllowedWidth : runningTabWidth;
        }
        Rectangle tabFolderBoundingBox = this.getEditArea().computeTrim(0, 0, contentSize.x, contentSize.y);
        contentSize.x = tabFolderBoundingBox.width;
        contentSize.y = tabFolderBoundingBox.height;
        this.getEditArea().layout(true);
        Rectangle rect = this.getEditArea().getClientArea();
        Point containerSize = new Point(rect.width, rect.height);
        int hdiff = contentSize.x - containerSize.x;
        int vdiff = contentSize.y - containerSize.y;
        if (hdiff > 0 || vdiff > 0) {
            hdiff = Math.max(0, hdiff);
            vdiff = Math.max(0, vdiff);
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + hdiff, shellSize.y + vdiff);
        }
    }

    public void updateButtons() {
        this.getTabViewer().refresh();
        this.getButton(0).setEnabled(this.getTabViewer().canSave());
    }

    protected void okPressed() {
        this.getTabViewer().handleApplyPressed();
        super.okPressed();
    }

    public int open() {
        this.setOpenMode(-1);
        return super.open();
    }

    protected String getDialogSettingsSectionName() {
        return IDebugUIConstants.PLUGIN_ID + ".LAUNCH_CONFIGURATION_PROPERTIES_DIALOG_SECTION";
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        if (this.getLaunchConfiguration().equals(manager.getMovedFrom(configuration))) {
            this.setLaunchConfiguration(configuration);
            this.getTabViewer().setInput(this.getLaunchConfiguration());
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }
}

