/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import org.eclipse.team.internal.ccvs.ssh.Cipher;
import org.eclipse.team.internal.ccvs.ssh.Misc;
import org.eclipse.team.internal.ccvs.ssh.Packet;

class ClientPacket
extends Packet {
    byte[] packet;

    public ClientPacket(int type, byte[] data, Cipher cipher) {
        int i;
        this.packetLength = data == null ? 5 : data.length + 5;
        this.paddingLength = 8 - this.packetLength % 8;
        this.packetType = type;
        this.packet = new byte[4 + this.paddingLength + this.packetLength];
        int packetOff = 0;
        Misc.writeInt(this.packetLength, this.packet, packetOff);
        packetOff += 4;
        if (cipher == null) {
            for (i = 0; i < this.paddingLength; ++i) {
                this.packet[packetOff++] = 0;
            }
        } else {
            Misc.random(this.packet, packetOff, this.paddingLength, false);
            packetOff += this.paddingLength;
        }
        this.packet[packetOff++] = (byte)this.packetType;
        if (data != null) {
            for (i = 0; i < data.length; ++i) {
                this.packet[packetOff++] = data[i];
            }
        }
        long crc = Misc.crc32(this.packet, 4, this.packet.length - 8, 0L);
        Misc.writeInt((int)crc, this.packet, packetOff);
        packetOff += 4;
        if (cipher != null) {
            cipher.encipher(this.packet, 4, this.packet, 4, this.packet.length - 4);
        }
    }

    public byte[] getBytes() {
        return this.packet;
    }
}

