/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.DialogMarkerProperties;
import org.eclipse.ui.views.markers.internal.Messages;

public class DialogTaskProperties
extends DialogMarkerProperties {
    private static final String PRIORITY_HIGH = Messages.getString("propertiesDialog.priorityHigh");
    private static final String PRIORITY_NORMAL = Messages.getString("propertiesDialog.priorityNormal");
    private static final String PRIORITY_LOW = Messages.getString("propertiesDialog.priorityLow");
    protected Combo priorityCombo;
    protected Button completedCheckbox;

    public DialogTaskProperties(Shell parentShell) {
        super(parentShell);
        this.setType("org.eclipse.core.resources.taskmarker");
    }

    DialogTaskProperties(Shell parentShell, String title) {
        super(parentShell, title);
        this.setType("org.eclipse.core.resources.taskmarker");
    }

    protected void createAttributesArea(Composite parent) {
        super.createAttributesArea(parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(Messages.getString("propertiesDialog.priority"));
        this.priorityCombo = new Combo(composite, 8);
        this.priorityCombo.setItems(new String[]{PRIORITY_HIGH, PRIORITY_NORMAL, PRIORITY_LOW});
        this.priorityCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.priorityCombo.setFont(composite.getFont());
        this.priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DialogTaskProperties.this.getMarker() == null) {
                    Map initialAttributes = DialogTaskProperties.this.getInitialAttributes();
                    initialAttributes.put("priority", new Integer(DialogTaskProperties.this.getPriorityFromDialog()));
                }
                DialogTaskProperties.this.markDirty();
            }
        });
        this.completedCheckbox = new Button(composite, 32);
        this.completedCheckbox.setFont(composite.getFont());
        this.completedCheckbox.setText(Messages.getString("propertiesDialog.completed"));
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        this.completedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DialogTaskProperties.this.getMarker() == null) {
                    Map initialAttributes = DialogTaskProperties.this.getInitialAttributes();
                    initialAttributes.put("done", new Boolean(DialogTaskProperties.this.completedCheckbox.getSelection()));
                }
                DialogTaskProperties.this.markDirty();
            }
        });
    }

    protected boolean getCompleted() {
        IMarker marker = this.getMarker();
        if (marker == null) {
            Map attributes = this.getInitialAttributes();
            Object done = attributes.get("done");
            return done != null && done instanceof Boolean && (Boolean)done != false;
        }
        return marker.getAttribute("done", false);
    }

    protected int getPriority() {
        IMarker marker = this.getMarker();
        int priority = 1;
        if (marker == null) {
            Map attributes = this.getInitialAttributes();
            Object priorityObj = attributes.get("priority");
            if (priorityObj != null && priorityObj instanceof Integer) {
                priority = (Integer)priorityObj;
            }
        } else {
            priority = marker.getAttribute("priority", 1);
        }
        return priority;
    }

    protected void updateEnablement() {
        super.updateEnablement();
        this.priorityCombo.setEnabled(this.isEditable());
        this.completedCheckbox.setEnabled(this.isEditable());
    }

    protected void updateDialogForNewMarker() {
        Map initialAttributes = this.getInitialAttributes();
        int priority = this.getPriority();
        initialAttributes.put("priority", new Integer(priority));
        if (priority == 2) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_HIGH));
        } else if (priority == 0) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_LOW));
        } else {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_NORMAL));
        }
        boolean completed = this.getCompleted();
        initialAttributes.put("done", new Boolean(completed));
        this.completedCheckbox.setSelection(completed);
        super.updateDialogForNewMarker();
    }

    protected void updateDialogFromMarker() {
        Map initialAttributes = this.getInitialAttributes();
        int priority = this.getPriority();
        initialAttributes.put("priority", new Integer(priority));
        if (priority == 2) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_HIGH));
        } else if (priority == 0) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_LOW));
        } else {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_NORMAL));
        }
        boolean completed = this.getCompleted();
        initialAttributes.put("done", new Boolean(completed));
        this.completedCheckbox.setSelection(completed);
        super.updateDialogFromMarker();
    }

    private int getPriorityFromDialog() {
        int priority = 1;
        if (this.priorityCombo.getSelectionIndex() == this.priorityCombo.indexOf(PRIORITY_HIGH)) {
            priority = 2;
        } else if (this.priorityCombo.getSelectionIndex() == this.priorityCombo.indexOf(PRIORITY_LOW)) {
            priority = 0;
        }
        return priority;
    }

    protected Map getMarkerAttributes() {
        Map attrs = super.getMarkerAttributes();
        attrs.put("priority", new Integer(this.getPriorityFromDialog()));
        attrs.put("done", new Boolean(this.completedCheckbox.getSelection()));
        Object userEditable = attrs.get("userEditable");
        if (userEditable == null || !(userEditable instanceof Boolean)) {
            attrs.put("userEditable", new Boolean(true));
        }
        return attrs;
    }
}

