/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class TypedElementSelectionValidator
implements ISelectionStatusValidator {
    private IStatus fgErrorStatus = new StatusInfo(4, "");
    private IStatus fgOKStatus = new StatusInfo();
    private Class[] fAcceptedTypes;
    private boolean fAllowMultipleSelection;
    private Collection fRejectedElements;

    public TypedElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
        this(acceptedTypes, allowMultipleSelection, null);
    }

    public TypedElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection, Collection rejectedElements) {
        Assert.isNotNull((Object)acceptedTypes);
        this.fAcceptedTypes = acceptedTypes;
        this.fAllowMultipleSelection = allowMultipleSelection;
        this.fRejectedElements = rejectedElements;
    }

    public IStatus validate(Object[] elements) {
        if (this.isValid(elements)) {
            return this.fgOKStatus;
        }
        return this.fgErrorStatus;
    }

    private boolean isOfAcceptedType(Object o) {
        for (int i = 0; i < this.fAcceptedTypes.length; ++i) {
            if (!this.fAcceptedTypes[i].isInstance(o)) continue;
            return true;
        }
        return false;
    }

    private boolean isRejectedElement(Object elem) {
        return this.fRejectedElements != null && this.fRejectedElements.contains(elem);
    }

    private boolean isValid(Object[] selection) {
        if (selection.length == 0) {
            return false;
        }
        if (!this.fAllowMultipleSelection && selection.length != 1) {
            return false;
        }
        for (int i = 0; i < selection.length; ++i) {
            Object o = selection[i];
            if (this.isOfAcceptedType(o) && !this.isRejectedElement(o)) continue;
            return false;
        }
        return true;
    }
}

