/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceFactoryRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceFactoryWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class IntroduceFactoryAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("IntroduceFactoryAction.dialog_title");

    public IntroduceFactoryAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public IntroduceFactoryAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("IntroduceFactoryAction.label"));
        this.setToolTipText(RefactoringMessages.getString("IntroduceFactoryAction.tooltipText"));
        this.setDescription(RefactoringMessages.getString("IntroduceFactoryAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.introduce_factory_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(IntroduceFactoryAction.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            if (IntroduceFactoryAction.canEnable(selection)) {
                ISourceRange nameRange;
                TextSelection textSel;
                IMethod method = IntroduceFactoryAction.getSingleSelectedMethod(selection);
                ICompilationUnit unit = method.getCompilationUnit();
                IntroduceFactoryRefactoring refactoring = IntroduceFactoryAction.createRefactoring(unit, (ITextSelection)(textSel = new TextSelection((nameRange = method.getNameRange()).getOffset(), nameRange.getLength())));
                if (refactoring == null) {
                    return;
                }
                new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("IntroduceFactoryAction.exception"));
        }
    }

    private static boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        return IntroduceFactoryRefactoring.isAvailable(IntroduceFactoryAction.getSingleSelectedMethod(selection));
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        if (selection.getFirstElement() instanceof IMethod) {
            return (IMethod)selection.getFirstElement();
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(ITextSelection selection) {
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return IntroduceFactoryRefactoring.isAvailable((IMethod)elements[0]);
        }
        return false;
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            IntroduceFactoryRefactoring refactoring = IntroduceFactoryAction.createRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("IntroduceFactoryAction.exception"));
        }
    }

    private static IntroduceFactoryRefactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return IntroduceFactoryRefactoring.create(cunit, selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private RefactoringWizard createWizard(IntroduceFactoryRefactoring refactoring) {
        String pageTitle = RefactoringMessages.getString("IntroduceFactoryAction.use_factory");
        return new IntroduceFactoryWizard(refactoring, pageTitle);
    }
}

