/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.CheckboxTablePart;
import org.eclipse.pde.internal.ui.util.OverlayIcon;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.WorkbenchHelp;

public class SourcePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static DirectoryDialog dialog;
    private static final String KEY_LABEL = "SourcePreferencePage.label";
    public static final String KEY_SELECT_ALL = "WizardCheckboxTablePart.selectAll";
    public static final String KEY_DESELECT_ALL = "WizardCheckboxTablePart.deselectAll";
    private static final String KEY_ADD = "SourcePreferencePage.add";
    private static final String KEY_DELETE = "SourcePreferencePage.delete";
    private static final String KEY_DESC = "SourcePreferencePage.desc";
    private CheckboxTablePart tablePart;
    private CheckboxTableViewer tableViewer;
    private Image extensionImage;
    private Image userImage;
    private Preferences preferences;
    private SourceLocation[] extensionLocations = new SourceLocation[0];
    private ArrayList userLocations = new ArrayList();

    public SourcePreferencePage() {
        this.tablePart = new LocationPart(new String[]{PDEPlugin.getResourceString(KEY_ADD), PDEPlugin.getResourceString("SourcePreferencePage.edit"), PDEPlugin.getResourceString(KEY_DELETE), null, PDEPlugin.getResourceString(KEY_SELECT_ALL), PDEPlugin.getResourceString(KEY_DESELECT_ALL)});
        this.extensionImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        OverlayIcon userDesc = new OverlayIcon(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"), new ImageDescriptor[][]{{PDEPluginImages.DESC_DOC_CO}});
        this.userImage = userDesc.createImage();
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.preferences = PDECore.getDefault().getPluginPreferences();
        this.initializeExtensionLocations();
        this.initializeUserlocations();
    }

    private void initializeExtensionLocations() {
        this.extensionLocations = PDECore.getDefault().getSourceLocationManager().getExtensionLocations();
    }

    private void initializeUserlocations() {
        this.userLocations = PDECore.getDefault().getSourceLocationManager().getUserLocationArray();
    }

    private String encodeSourceLocations(Object[] locations) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < locations.length; ++i) {
            SourceLocation loc = (SourceLocation)locations[i];
            if (i > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(this.encodeSourceLocation(loc));
        }
        return buf.toString();
    }

    private String encodeSourceLocation(SourceLocation location) {
        return location.getPath().toOSString() + "," + (location.isEnabled() ? "t" : "f");
    }

    public void dispose() {
        super.dispose();
        this.userImage.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.preferences.setValue("ext_locations", this.encodeSourceLocations(this.extensionLocations));
        this.preferences.setValue("source_locations", this.encodeSourceLocations(this.userLocations.toArray()));
        PDECore.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public void performDefaults() {
        SourceLocation location;
        int i;
        for (i = 0; i < this.extensionLocations.length; ++i) {
            location = this.extensionLocations[i];
            location.setEnabled(true);
            this.tableViewer.setChecked((Object)location, true);
        }
        for (i = 0; i < this.userLocations.size(); ++i) {
            location = (SourceLocation)this.userLocations.get(i);
            location.setEnabled(false);
            this.tableViewer.setChecked((Object)location, false);
        }
        this.tableViewer.refresh();
        super.performDefaults();
    }

    private Object[] getLocations() {
        Object[] merged = new Object[this.extensionLocations.length + this.userLocations.size()];
        System.arraycopy(this.extensionLocations, 0, merged, 0, this.extensionLocations.length);
        System.arraycopy(this.userLocations.toArray(), 0, merged, this.extensionLocations.length, this.userLocations.size());
        return merged;
    }

    private void selectAll(boolean selected) {
        int i;
        for (i = 0; i < this.extensionLocations.length; ++i) {
            this.extensionLocations[i].setEnabled(selected);
        }
        for (i = 0; i < this.userLocations.size(); ++i) {
            ((SourceLocation)this.userLocations.get(i)).setEnabled(selected);
        }
        this.tableViewer.setAllChecked(selected);
    }

    private void handleAdd() {
        String path = this.getDirectoryDialog(null).open();
        if (path != null) {
            SourceLocation location = new SourceLocation((IPath)new Path(path), true);
            this.userLocations.add(location);
            this.tableViewer.add((Object)location);
            this.tableViewer.setChecked((Object)location, location.isEnabled());
        }
    }

    private void handleEdit() {
        IStructuredSelection ssel = (IStructuredSelection)this.tableViewer.getSelection();
        SourceLocation loc = (SourceLocation)ssel.getFirstElement();
        String path = this.getDirectoryDialog(loc.getPath().toOSString()).open();
        if (path != null) {
            loc.setPath((IPath)new Path(path));
            this.tableViewer.refresh();
        }
    }

    private DirectoryDialog getDirectoryDialog(String filterPath) {
        if (dialog == null) {
            dialog = new DirectoryDialog(this.getShell());
        }
        dialog.setMessage(PDEPlugin.getResourceString("SourcePreferencePage.dialogMessage"));
        if (filterPath != null) {
            dialog.setFilterPath(filterPath);
        }
        return dialog;
    }

    private void handleDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        SourceLocation location = (SourceLocation)selection.getFirstElement();
        this.userLocations.remove(location);
        this.tableViewer.remove((Object)location);
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.tablePart.setMinimumSize(150, 200);
        this.tablePart.createControl(container, 2048, 2, null);
        this.tableViewer = this.tablePart.getTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new SourceProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SourceLabelProvider());
        this.tableViewer.setInput((Object)this);
        this.initializeStates();
        this.tablePart.setButtonEnabled(1, false);
        this.tablePart.setButtonEnabled(2, false);
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.source_preference_page");
        return container;
    }

    private void initializeStates() {
        SourceLocation loc;
        int i;
        for (i = 0; i < this.extensionLocations.length; ++i) {
            loc = this.extensionLocations[i];
            this.tableViewer.setChecked((Object)loc, loc.isEnabled());
        }
        for (i = 0; i < this.userLocations.size(); ++i) {
            loc = (SourceLocation)this.userLocations.get(i);
            this.tableViewer.setChecked((Object)loc, loc.isEnabled());
        }
    }

    class LocationPart
    extends CheckboxTablePart {
        public LocationPart(String[] buttonLabels) {
            super(buttonLabels);
        }

        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    SourcePreferencePage.this.handleAdd();
                    break;
                }
                case 1: {
                    SourcePreferencePage.this.handleEdit();
                    break;
                }
                case 2: {
                    SourcePreferencePage.this.handleDelete();
                    break;
                }
                case 4: {
                    SourcePreferencePage.this.selectAll(true);
                    break;
                }
                case 5: {
                    SourcePreferencePage.this.selectAll(false);
                }
            }
        }

        protected Button createButton(Composite parent, String label, int index, FormToolkit toolkit) {
            Button button = super.createButton(parent, label, index, toolkit);
            SWTUtil.setButtonDimensionHint(button);
            return button;
        }

        protected void createMainLabel(Composite parent, int span, FormToolkit toolkit) {
            Label label = new Label(parent, 0);
            label.setText(PDEPlugin.getResourceString(SourcePreferencePage.KEY_LABEL));
            GridData gd = new GridData(4);
            gd.horizontalSpan = span;
            label.setLayoutData((Object)gd);
        }

        protected void selectionChanged(IStructuredSelection selection) {
            boolean enabled = false;
            if (!selection.isEmpty()) {
                SourceLocation loc = (SourceLocation)selection.getFirstElement();
                enabled = loc.isUserDefined();
            }
            SourcePreferencePage.this.tablePart.setButtonEnabled(1, enabled);
            SourcePreferencePage.this.tablePart.setButtonEnabled(2, enabled);
        }

        protected void elementChecked(Object element, boolean checked) {
            ((SourceLocation)element).setEnabled(checked);
        }
    }

    class SourceLabelProvider
    extends LabelProvider {
        SourceLabelProvider() {
        }

        public String getText(Object obj) {
            SourceLocation location = (SourceLocation)obj;
            return location.getPath().toOSString();
        }

        public Image getImage(Object obj) {
            SourceLocation location = (SourceLocation)obj;
            return location.isUserDefined() ? SourcePreferencePage.this.userImage : SourcePreferencePage.this.extensionImage;
        }
    }

    class SourceProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        SourceProvider() {
        }

        public Object[] getElements(Object input) {
            return SourcePreferencePage.this.getLocations();
        }
    }
}

