/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.IVariableResolver;
import org.eclipse.core.internal.expressions.Assert;
import org.eclipse.core.runtime.CoreException;

public class EvaluationContext
implements IEvaluationContext {
    private IEvaluationContext fParent;
    private Object fDefaultVariable;
    private Map fVariables;
    private IVariableResolver[] fVariableResolvers;

    public EvaluationContext(IEvaluationContext parent, Object defaultVariable) {
        Assert.isNotNull(defaultVariable);
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
    }

    public EvaluationContext(IEvaluationContext parent, Object defaultVariable, IVariableResolver[] resolvers) {
        Assert.isNotNull(defaultVariable);
        Assert.isNotNull(resolvers);
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
        this.fVariableResolvers = resolvers;
    }

    public IEvaluationContext getParent() {
        return this.fParent;
    }

    public IEvaluationContext getRoot() {
        if (this.fParent == null) {
            return this;
        }
        return this.fParent.getRoot();
    }

    public Object getDefaultVariable() {
        return this.fDefaultVariable;
    }

    public void addVariable(String name, Object value) {
        Assert.isNotNull(name);
        Assert.isNotNull(value);
        if (this.fVariables == null) {
            this.fVariables = new HashMap();
        }
        this.fVariables.put(name, value);
    }

    public Object removeVariable(String name) {
        Assert.isNotNull(name);
        if (this.fVariables == null) {
            return null;
        }
        return this.fVariables.remove(name);
    }

    public Object getVariable(String name) {
        Assert.isNotNull(name);
        Object result = null;
        if (this.fVariables != null) {
            result = this.fVariables.get(name);
        }
        if (result != null) {
            return result;
        }
        if (this.fParent != null) {
            return this.fParent.getVariable(name);
        }
        return null;
    }

    public Object resolveVariable(String name, Object[] args) throws CoreException {
        if (this.fVariableResolvers != null && this.fVariableResolvers.length > 0) {
            for (int i = 0; i < this.fVariableResolvers.length; ++i) {
                IVariableResolver resolver = this.fVariableResolvers[i];
                Object variable = resolver.resolve(name, args);
                if (variable == null) continue;
                return variable;
            }
        }
        if (this.fParent != null) {
            return this.fParent.resolveVariable(name, args);
        }
        return null;
    }
}

