/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.JobChangeEvent;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;

class JobListeners {
    static final IJobChangeListener[] EMPTY_LISTENERS = new IJobChangeListener[0];
    private final IListenerDoit aboutToRun = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.aboutToRun(event);
        }
    };
    private final IListenerDoit awake = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.awake(event);
        }
    };
    private final IListenerDoit done = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.done(event);
        }
    };
    private final IListenerDoit running = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.running(event);
        }
    };
    private final IListenerDoit scheduled = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.scheduled(event);
        }
    };
    private final IListenerDoit sleeping = new IListenerDoit(){

        public void notify(IJobChangeListener listener, IJobChangeEvent event) {
            listener.sleeping(event);
        }
    };
    protected volatile IJobChangeListener[] global = EMPTY_LISTENERS;

    JobListeners() {
    }

    static JobChangeEvent newEvent(Job job) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        return instance;
    }

    static JobChangeEvent newEvent(Job job, IStatus result) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        instance.result = result;
        return instance;
    }

    static JobChangeEvent newEvent(Job job, long delay) {
        JobChangeEvent instance = new JobChangeEvent();
        instance.job = job;
        instance.delay = delay;
        return instance;
    }

    private void doNotify(IListenerDoit doit, IJobChangeEvent event) {
        int i;
        IJobChangeListener[] listeners = this.global;
        int size = listeners.length;
        for (i = 0; i < size; ++i) {
            try {
                if (listeners[i] == null) continue;
                doit.notify(listeners[i], event);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
                continue;
            }
            catch (LinkageError e) {
                this.handleException(e);
            }
        }
        listeners = event.getJob().getListeners();
        if (listeners == null) {
            return;
        }
        size = listeners.length;
        for (i = 0; i < size; ++i) {
            try {
                if (listeners[i] == null) continue;
                doit.notify(listeners[i], event);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
                continue;
            }
            catch (LinkageError e) {
                this.handleException(e);
            }
        }
    }

    private void handleException(Throwable e) {
        if (e instanceof OperationCanceledException) {
            return;
        }
        String pluginId = "org.eclipse.core.runtime";
        String message = Policy.bind("meta.pluginProblems", pluginId);
        Status status = new Status(4, pluginId, 2, message, e);
        if (InternalPlatform.getDefault().isRunning()) {
            InternalPlatform.getDefault().log(status);
        } else {
            e.printStackTrace();
        }
    }

    public synchronized void add(IJobChangeListener listener) {
        IJobChangeListener[] tempListeners = this.global;
        int oldCount = tempListeners.length;
        for (int i = 0; i < oldCount; ++i) {
            if (tempListeners[i] != listener) continue;
            return;
        }
        IJobChangeListener[] newListeners = new IJobChangeListener[tempListeners.length + 1];
        System.arraycopy(tempListeners, 0, newListeners, 0, oldCount);
        newListeners[oldCount] = listener;
        this.global = newListeners;
    }

    public synchronized void remove(IJobChangeListener listener) {
        IJobChangeListener[] tempListeners = this.global;
        int oldCount = tempListeners.length;
        if (oldCount == 0 || oldCount == 1 && tempListeners[0] == listener) {
            this.global = EMPTY_LISTENERS;
            return;
        }
        for (int i = 0; i < oldCount; ++i) {
            if (tempListeners[i] != listener) continue;
            IJobChangeListener[] newListeners = new IJobChangeListener[oldCount - 1];
            System.arraycopy(tempListeners, 0, newListeners, 0, i);
            System.arraycopy(tempListeners, i + 1, newListeners, i, oldCount - i - 1);
            this.global = newListeners;
            return;
        }
    }

    public void aboutToRun(Job job) {
        this.doNotify(this.aboutToRun, JobListeners.newEvent(job));
    }

    public void awake(Job job) {
        this.doNotify(this.awake, JobListeners.newEvent(job));
    }

    public void done(Job job, IStatus result, boolean reschedule) {
        JobChangeEvent event = JobListeners.newEvent(job, result);
        event.reschedule = reschedule;
        this.doNotify(this.done, event);
    }

    public void running(Job job) {
        this.doNotify(this.running, JobListeners.newEvent(job));
    }

    public void scheduled(Job job, long delay, boolean reschedule) {
        JobChangeEvent event = JobListeners.newEvent(job, delay);
        event.reschedule = reschedule;
        this.doNotify(this.scheduled, event);
    }

    public void sleeping(Job job) {
        this.doNotify(this.sleeping, JobListeners.newEvent(job));
    }

    static interface IListenerDoit {
        public void notify(IJobChangeListener var1, IJobChangeEvent var2);
    }
}

