/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts.ws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.contexts.NotDefinedException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.contexts.ContextManagerFactory;
import org.eclipse.ui.internal.contexts.IMutableContextManager;
import org.eclipse.ui.internal.contexts.ProxyContextManager;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.internal.misc.Policy;

public class WorkbenchContextSupport
implements IWorkbenchContextSupport {
    private static final boolean DEBUG = Policy.DEBUG_CONTEXTS;
    private static final int DEBUG_STACK_LENGTH_TO_SHOW = 5;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_CONTEXTS_VERBOSE;
    private Listener activationListener = new Listener(){

        public void handleEvent(Event event) {
            WorkbenchContextSupport.this.checkWindowType(event.display.getActiveShell());
        }
    };
    private Shell activeShell;
    private IWorkbenchSite activeWorkbenchSite;
    private IWorkbenchWindow activeWorkbenchWindow;
    private Map enabledSubmissionsByContextId = new HashMap();
    private WorkbenchKeyboard keyboard;
    private volatile boolean keyFilterEnabled;
    private IMutableContextManager mutableContextManager;
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage workbenchPage) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void pageClosed(IWorkbenchPage workbenchPage) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void pageOpened(IWorkbenchPage workbenchPage) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }

        public void perspectiveChanged(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor, String changeId) {
            WorkbenchContextSupport.this.processEnabledSubmissions(false);
        }
    };
    private boolean processing = true;
    private ProxyContextManager proxyContextManager;
    private final Map registeredWindows = new WeakHashMap();
    private Workbench workbench;

    private final Map createContextTreeFor(Set contextIds) {
        HashMap<String, String> contextTree = new HashMap<String, String>();
        IContextManager contextManager = this.getContextManager();
        Iterator contextIdItr = contextIds.iterator();
        block2: while (contextIdItr.hasNext()) {
            String childContextId = (String)contextIdItr.next();
            while (childContextId != null) {
                IContext childContext = contextManager.getContext(childContextId);
                try {
                    String parentContextId = childContext.getParentId();
                    contextTree.put(childContextId, parentContextId);
                    childContextId = parentContextId;
                }
                catch (NotDefinedException e) {
                    continue block2;
                }
            }
        }
        return contextTree;
    }

    public final Map createFilteredContextTreeFor(Set contextIds) {
        block9: {
            String contextId;
            boolean dialog = false;
            boolean window = false;
            Iterator contextIdItr = contextIds.iterator();
            while (contextIdItr.hasNext()) {
                contextId = (String)contextIdItr.next();
                if ("org.eclipse.ui.contexts.dialog".equals(contextId)) {
                    dialog = true;
                    continue;
                }
                if (!"org.eclipse.ui.contexts.window".equals(contextId)) continue;
                window = true;
            }
            try {
                contextIdItr = contextIds.iterator();
                block3: while (contextIdItr.hasNext()) {
                    contextId = (String)contextIdItr.next();
                    IContext context = this.mutableContextManager.getContext(contextId);
                    String parentId = context.getParentId();
                    while (parentId != null) {
                        if ("org.eclipse.ui.contexts.dialog".equals(parentId)) {
                            if (dialog) continue block3;
                            contextIdItr.remove();
                            continue block3;
                        }
                        if ("org.eclipse.ui.contexts.window".equals(parentId)) {
                            if (window) continue block3;
                            contextIdItr.remove();
                            continue block3;
                        }
                        if ("org.eclipse.ui.contexts.dialogAndWindow".equals(parentId)) {
                            if (window || dialog) continue block3;
                            contextIdItr.remove();
                            continue block3;
                        }
                        context = this.mutableContextManager.getContext(parentId);
                        parentId = context.getParentId();
                    }
                }
            }
            catch (NotDefinedException e) {
                if (!DEBUG) break block9;
                System.out.println("CONTEXTS >>> NotDefinedException('" + e.getMessage() + "') while filtering dialog/window contexts");
            }
        }
        return this.createContextTreeFor(contextIds);
    }

    public WorkbenchContextSupport(Workbench workbenchToSupport) {
        this.workbench = workbenchToSupport;
        this.mutableContextManager = ContextManagerFactory.getMutableContextManager();
        this.proxyContextManager = new ProxyContextManager(this.mutableContextManager);
        workbenchToSupport.getDisplay().addFilter(26, this.activationListener);
    }

    public void addEnabledSubmission(EnabledSubmission enabledSubmission) {
        this.addEnabledSubmissionReal(enabledSubmission);
        this.processEnabledSubmissions(true);
    }

    private final void addEnabledSubmissionReal(EnabledSubmission enabledSubmission) {
        String contextId = enabledSubmission.getContextId();
        ArrayList<EnabledSubmission> enabledSubmissions2 = (ArrayList<EnabledSubmission>)this.enabledSubmissionsByContextId.get(contextId);
        if (enabledSubmissions2 == null) {
            enabledSubmissions2 = new ArrayList<EnabledSubmission>();
            this.enabledSubmissionsByContextId.put(contextId, enabledSubmissions2);
        }
        enabledSubmissions2.add(enabledSubmission);
    }

    public void addEnabledSubmissions(Collection enabledSubmissions) {
        Iterator submissionItr = enabledSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.addEnabledSubmissionReal((EnabledSubmission)submissionItr.next());
        }
        this.processEnabledSubmissions(true);
    }

    private final void checkWindowType(final Shell newShell) {
        boolean submissionsProcessed = false;
        Shell oldShell = this.activeShell;
        if (newShell != oldShell) {
            List oldSubmissions = (List)this.registeredWindows.get(oldShell);
            if (oldSubmissions == null && (oldSubmissions = (List)this.registeredWindows.get(null)) != null) {
                this.removeEnabledSubmissions(oldSubmissions);
                submissionsProcessed = true;
            }
            if (newShell != null && !newShell.isDisposed()) {
                ArrayList<EnabledSubmission> newSubmissions;
                if (newShell.getParent() != null && this.registeredWindows.get(newShell) == null) {
                    newSubmissions = new ArrayList<EnabledSubmission>();
                    newSubmissions.add(new EnabledSubmission(null, newShell, null, "org.eclipse.ui.contexts.dialogAndWindow"));
                    newSubmissions.add(new EnabledSubmission(null, newShell, null, "org.eclipse.ui.contexts.dialog"));
                    this.registeredWindows.put(null, newSubmissions);
                    newShell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            WorkbenchContextSupport.this.registeredWindows.remove(null);
                            WorkbenchContextSupport.this.removeEnabledSubmissions(newSubmissions);
                            newShell.removeDisposeListener((DisposeListener)this);
                        }
                    });
                } else {
                    newSubmissions = (ArrayList<EnabledSubmission>)this.registeredWindows.get(newShell);
                }
                if (newSubmissions != null) {
                    this.addEnabledSubmissions(newSubmissions);
                    submissionsProcessed = true;
                }
            }
        }
        if (!submissionsProcessed) {
            this.processEnabledSubmissions(false, newShell);
        }
    }

    public IContextManager getContextManager() {
        return this.proxyContextManager;
    }

    public final WorkbenchKeyboard getKeyboard() {
        return this.keyboard;
    }

    public final void initialize() {
        this.keyboard = new WorkbenchKeyboard(this.workbench, this.workbench.getActivitySupport().getActivityManager(), this.workbench.getCommandSupport().getCommandManager());
        this.setKeyFilterEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeyFilterEnabled() {
        WorkbenchKeyboard workbenchKeyboard = this.keyboard;
        synchronized (workbenchKeyboard) {
            return this.keyFilterEnabled;
        }
    }

    private void processEnabledSubmissions(boolean force) {
        this.processEnabledSubmissions(force, this.workbench.getDisplay().getActiveShell());
    }

    public void processEnabledSubmissions(boolean force, Shell newActiveShell) {
        IWorkbenchPart activeWorkbenchPart;
        IWorkbenchPage activeWorkbenchPage;
        if (!this.processing) {
            return;
        }
        IWorkbenchPartSite newActiveWorkbenchSite = null;
        IWorkbenchWindow newActiveWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        boolean update = false;
        if (this.activeShell != newActiveShell) {
            this.activeShell = newActiveShell;
            update = true;
        }
        if (this.activeWorkbenchWindow != newActiveWorkbenchWindow) {
            if (this.activeWorkbenchWindow != null) {
                this.activeWorkbenchWindow.removePageListener(this.pageListener);
                this.activeWorkbenchWindow.removePerspectiveListener(this.perspectiveListener);
                this.activeWorkbenchWindow.getPartService().removePartListener(this.partListener);
            }
            if (newActiveWorkbenchWindow != null) {
                newActiveWorkbenchWindow.addPageListener(this.pageListener);
                newActiveWorkbenchWindow.addPerspectiveListener(this.perspectiveListener);
                newActiveWorkbenchWindow.getPartService().addPartListener(this.partListener);
            }
            this.activeWorkbenchWindow = newActiveWorkbenchWindow;
            update = true;
        }
        if (newActiveWorkbenchWindow != null && (activeWorkbenchPage = newActiveWorkbenchWindow.getActivePage()) != null && (activeWorkbenchPart = activeWorkbenchPage.getActivePart()) != null) {
            newActiveWorkbenchSite = activeWorkbenchPart.getSite();
        }
        if (force || update || this.activeWorkbenchSite != newActiveWorkbenchSite) {
            this.activeWorkbenchSite = newActiveWorkbenchSite;
            HashSet<String> enabledContextIds = new HashSet<String>();
            Iterator iterator = this.enabledSubmissionsByContextId.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String contextId = (String)entry.getKey();
                List enabledSubmissions = (List)entry.getValue();
                for (int i = 0; i < enabledSubmissions.size(); ++i) {
                    IWorkbenchPartSite activeWorkbenchSite2;
                    EnabledSubmission enabledSubmission = (EnabledSubmission)enabledSubmissions.get(i);
                    Shell activeShell2 = enabledSubmission.getActiveShell();
                    if (activeShell2 != null && activeShell2 != newActiveShell || (activeWorkbenchSite2 = enabledSubmission.getActiveWorkbenchPartSite()) != null && activeWorkbenchSite2 != newActiveWorkbenchSite) continue;
                    enabledContextIds.add(contextId);
                    continue block0;
                }
            }
            if (DEBUG && !this.mutableContextManager.getEnabledContextIds().equals(enabledContextIds)) {
                System.out.println("CONTEXTS >>> " + enabledContextIds);
                if (DEBUG_VERBOSE) {
                    Exception exception = new Exception();
                    exception.fillInStackTrace();
                    StackTraceElement[] stackTrace = exception.getStackTrace();
                    int elementsToShow = stackTrace.length < 5 ? stackTrace.length : 5;
                    for (int i = 0; i < elementsToShow; ++i) {
                        StackTraceElement element = stackTrace[i];
                        System.out.println("CONTEXTS >>>     " + element.toString());
                    }
                }
            }
            this.mutableContextManager.setEnabledContextIds(enabledContextIds);
        }
    }

    public boolean registerShell(final Shell shell, int type) {
        if (shell == null) {
            throw new NullPointerException("The shell was null");
        }
        final ArrayList<EnabledSubmission> submissions = new ArrayList<EnabledSubmission>();
        switch (type) {
            case 0: {
                submissions.add(new EnabledSubmission(null, shell, null, "org.eclipse.ui.contexts.dialogAndWindow"));
                submissions.add(new EnabledSubmission(null, shell, null, "org.eclipse.ui.contexts.dialog"));
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                submissions.add(new EnabledSubmission(null, shell, null, "org.eclipse.ui.contexts.dialogAndWindow"));
                submissions.add(new EnabledSubmission(null, shell, null, "org.eclipse.ui.contexts.window"));
                break;
            }
            default: {
                throw new IllegalArgumentException("The type is not recognized: " + type);
            }
        }
        boolean returnValue = false;
        List previousSubmissions = (List)this.registeredWindows.get(shell);
        if (previousSubmissions != null) {
            returnValue = true;
            this.removeEnabledSubmissions(previousSubmissions);
        }
        this.registeredWindows.put(shell, submissions);
        this.addEnabledSubmissions(submissions);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkbenchContextSupport.this.registeredWindows.remove(shell);
                WorkbenchContextSupport.this.removeEnabledSubmissions(submissions);
            }
        });
        return returnValue;
    }

    public void removeEnabledSubmission(EnabledSubmission enabledSubmission) {
        this.removeEnabledSubmissionReal(enabledSubmission);
        this.processEnabledSubmissions(true);
    }

    private final void removeEnabledSubmissionReal(EnabledSubmission enabledSubmission) {
        String contextId = enabledSubmission.getContextId();
        List enabledSubmissions2 = (List)this.enabledSubmissionsByContextId.get(contextId);
        if (enabledSubmissions2 != null) {
            enabledSubmissions2.remove(enabledSubmission);
            if (enabledSubmissions2.isEmpty()) {
                this.enabledSubmissionsByContextId.remove(contextId);
            }
        }
    }

    public void removeEnabledSubmissions(Collection enabledSubmissions) {
        Iterator submissionItr = enabledSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.removeEnabledSubmissionReal((EnabledSubmission)submissionItr.next());
        }
        this.processEnabledSubmissions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyFilterEnabled(boolean enabled) {
        WorkbenchKeyboard workbenchKeyboard = this.keyboard;
        synchronized (workbenchKeyboard) {
            Display currentDisplay = Display.getCurrent();
            Listener keyFilter = this.keyboard.getKeyDownFilter();
            if (enabled) {
                currentDisplay.addFilter(1, keyFilter);
                currentDisplay.addFilter(31, keyFilter);
            } else {
                currentDisplay.removeFilter(1, keyFilter);
                currentDisplay.removeFilter(31, keyFilter);
            }
            this.keyFilterEnabled = enabled;
        }
    }

    public boolean unregisterShell(Shell shell) {
        if (shell == null) {
            return false;
        }
        List previousSubmissions = (List)this.registeredWindows.get(shell);
        if (previousSubmissions != null) {
            this.registeredWindows.remove(shell);
            this.removeEnabledSubmissions(previousSubmissions);
            return true;
        }
        return false;
    }

    public final void setProcessing(boolean processing) {
        boolean reprocess = !this.processing && processing;
        this.processing = processing;
        if (reprocess) {
            this.processEnabledSubmissions(true);
        }
    }
}

