/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;

public class StatusUtil {
    protected static List flatten(IStatus aStatus) {
        ArrayList result = new ArrayList();
        if (aStatus.isMultiStatus()) {
            IStatus[] children = aStatus.getChildren();
            for (int i = 0; i < children.length; ++i) {
                IStatus currentChild = children[i];
                if (currentChild.isMultiStatus()) {
                    Iterator childStatiiEnum = StatusUtil.flatten(currentChild).iterator();
                    while (childStatiiEnum.hasNext()) {
                        result.add(childStatiiEnum.next());
                    }
                    continue;
                }
                result.add(currentChild);
            }
        } else {
            result.add(aStatus);
        }
        return result;
    }

    protected static IStatus newStatus(IStatus[] stati, String message, Throwable exception) {
        Assert.isTrue(message != null);
        Assert.isTrue(message.trim().length() != 0);
        return new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 4, stati, message, exception);
    }

    public static IStatus newStatus(int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().length() == 0) {
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, WorkbenchPlugin.PI_WORKBENCH, severity, statusMessage, exception);
    }

    public static IStatus newStatus(List children, String message, Throwable exception) {
        ArrayList flatStatusCollection = new ArrayList();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IStatus currentStatus = (IStatus)iter.next();
            Iterator childrenIter = StatusUtil.flatten(currentStatus).iterator();
            while (childrenIter.hasNext()) {
                flatStatusCollection.add(childrenIter.next());
            }
        }
        IStatus[] stati = new IStatus[flatStatusCollection.size()];
        flatStatusCollection.toArray(stati);
        return StatusUtil.newStatus(stati, message, exception);
    }
}

