/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferencePageRegistryReader
extends RegistryReader {
    public static final String ATT_CATEGORY = "category";
    public static final String ATT_CLASS = "class";
    public static final String ATT_NAME = "name";
    public static final String ATT_ID = "id";
    public static final String TAG_PAGE = "page";
    public static final String ATT_ICON = "icon";
    public static final String PREFERENCE_SEPARATOR = "/";
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((CategoryNode)arg0).getFlatCategory();
            String s2 = ((CategoryNode)arg1).getFlatCategory();
            return this.collator.compare(s1, s2);
        }
    };
    private List nodes;
    private IWorkbench workbench;

    public PreferencePageRegistryReader(IWorkbench newWorkbench) {
        this.workbench = newWorkbench;
    }

    private WorkbenchPreferenceNode findNode(String id) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)this.nodes.get(i);
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    private WorkbenchPreferenceNode findNode(WorkbenchPreferenceNode parent, String id) {
        IPreferenceNode[] subNodes = parent.getSubNodes();
        for (int i = 0; i < subNodes.length; ++i) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)subNodes[i];
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    public List getPreferenceContributions(IExtensionRegistry registry) {
        this.loadNodesFromRegistry(registry);
        ArrayList<WorkbenchPreferenceNode> contributions = new ArrayList<WorkbenchPreferenceNode>();
        WorkbenchPreferenceNode favorite = null;
        String favoriteId = ((Workbench)this.workbench).getMainPreferencePageId();
        if (favoriteId != null) {
            favorite = this.findNode(favoriteId);
        }
        if (favorite != null) {
            contributions.add(favorite);
        }
        Object[] sortedNodes = this.sortByCategories(this.nodes);
        for (int i = 0; i < sortedNodes.length; ++i) {
            CategoryNode categoryNode = (CategoryNode)sortedNodes[i];
            WorkbenchPreferenceNode node = categoryNode.getNode();
            if (node == favorite) continue;
            String category = node.getCategory();
            if (category == null) {
                contributions.add(node);
                continue;
            }
            StringTokenizer tokenizer = new StringTokenizer(category, PREFERENCE_SEPARATOR);
            WorkbenchPreferenceNode parent = null;
            while (tokenizer.hasMoreElements()) {
                String currentToken = tokenizer.nextToken();
                WorkbenchPreferenceNode child = null;
                child = parent == null ? this.findNode(currentToken) : this.findNode(parent, currentToken);
                if (child == null) {
                    parent = null;
                    break;
                }
                parent = child;
            }
            if (parent != null) {
                parent.add((IPreferenceNode)node);
                continue;
            }
            WorkbenchPlugin.log("Invalid preference page path: " + categoryNode.getFlatCategory());
            contributions.add(node);
        }
        return contributions;
    }

    protected void loadNodesFromRegistry(IExtensionRegistry registry) {
        this.nodes = new ArrayList();
        this.readRegistry(registry, "org.eclipse.ui", "preferencePages");
    }

    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_PAGE)) {
            return false;
        }
        WorkbenchPreferenceNode node = PreferencePageRegistryReader.createNode(this.workbench, element);
        if (node != null) {
            this.nodes.add(node);
        }
        this.readElementChildren(element);
        return true;
    }

    public static WorkbenchPreferenceNode createNode(IWorkbench workbench, IConfigurationElement element) {
        String name = element.getAttribute(ATT_NAME);
        String id = element.getAttribute(ATT_ID);
        String category = element.getAttribute(ATT_CATEGORY);
        String imageName = element.getAttribute(ATT_ICON);
        String className = element.getAttribute(ATT_CLASS);
        if (name == null) {
            PreferencePageRegistryReader.logMissingAttribute(element, ATT_NAME);
        }
        if (id == null) {
            PreferencePageRegistryReader.logMissingAttribute(element, ATT_ID);
        }
        if (className == null) {
            PreferencePageRegistryReader.logMissingAttribute(element, ATT_CLASS);
        }
        if (name == null || id == null || className == null) {
            return null;
        }
        ImageDescriptor image = null;
        if (imageName != null) {
            String contributingPluginId = element.getDeclaringExtension().getNamespace();
            image = AbstractUIPlugin.imageDescriptorFromPlugin(contributingPluginId, imageName);
        }
        WorkbenchPreferenceNode node = new WorkbenchPreferenceNode(id, name, category, image, element, workbench);
        return node;
    }

    private Object[] sortByCategories(List categoryNodes) {
        Object[] nodeArray = new CategoryNode[categoryNodes.size()];
        for (int i = 0; i < categoryNodes.size(); ++i) {
            nodeArray[i] = new CategoryNode((WorkbenchPreferenceNode)categoryNodes.get(i));
        }
        Collections.sort(Arrays.asList(nodeArray), comparer);
        return nodeArray;
    }

    class CategoryNode {
        private WorkbenchPreferenceNode node;
        private String flatCategory;

        public CategoryNode(WorkbenchPreferenceNode node) {
            this.node = node;
        }

        public WorkbenchPreferenceNode getNode() {
            return this.node;
        }

        public String getFlatCategory() {
            if (this.flatCategory == null) {
                this.initialize();
                if (this.flatCategory == null) {
                    this.flatCategory = this.node.getLabelText();
                }
            }
            return this.flatCategory;
        }

        private void initialize() {
            String category = this.node.getCategory();
            if (category == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            StringTokenizer stok = new StringTokenizer(category, PreferencePageRegistryReader.PREFERENCE_SEPARATOR);
            WorkbenchPreferenceNode immediateParent = null;
            while (stok.hasMoreTokens()) {
                String pathID = stok.nextToken();
                immediateParent = PreferencePageRegistryReader.this.findNode(pathID);
                if (immediateParent == null) {
                    return;
                }
                if (sb.length() > 0) {
                    sb.append(PreferencePageRegistryReader.PREFERENCE_SEPARATOR);
                }
                sb.append(immediateParent.getLabelText());
            }
            if (sb.length() > 0) {
                sb.append(PreferencePageRegistryReader.PREFERENCE_SEPARATOR);
            }
            sb.append(this.node.getLabelText());
            this.flatCategory = sb.toString();
        }
    }
}

