/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WizardsRegistryReader
extends RegistryReader {
    private AdaptableList wizards;
    private String pluginPoint;
    protected static final String TAG_WIZARD = "wizard";
    protected static final String ATT_NAME = "name";
    public static final String ATT_CLASS = "class";
    protected static final String ATT_ICON = "icon";
    protected static final String ATT_ID = "id";
    protected static final String trueString = "TRUE";

    public WizardsRegistryReader(String pluginPointId) {
        this.pluginPoint = pluginPointId;
    }

    protected void addNewElementToResult(WorkbenchWizardElement wizard, IConfigurationElement config) {
        this.wizards.add(wizard);
    }

    protected void createEmptyWizardCollection() {
        this.wizards = new AdaptableList();
    }

    protected WorkbenchWizardElement createWizardElement(IConfigurationElement element) {
        String nameString = element.getAttribute(ATT_NAME);
        if (nameString == null) {
            WizardsRegistryReader.logMissingAttribute(element, ATT_NAME);
            return null;
        }
        WorkbenchWizardElement result = new WorkbenchWizardElement(nameString);
        if (this.initializeWizard(result, element)) {
            return result;
        }
        return null;
    }

    public WorkbenchWizardElement findWizard(String id) {
        Object[] wizards = this.getWizardCollectionElements();
        for (int nX = 0; nX < wizards.length; ++nX) {
            WizardCollectionElement collection = (WizardCollectionElement)wizards[nX];
            WorkbenchWizardElement element = collection.findWizard(id, true);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public AdaptableList getWizards() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizards;
    }

    protected boolean initializeWizard(WorkbenchWizardElement element, IConfigurationElement config) {
        element.setID(config.getAttribute(ATT_ID));
        element.setDescription(this.getDescription(config));
        element.setConfigurationElement(config);
        String iconName = config.getAttribute(ATT_ICON);
        if (iconName != null) {
            IExtension extension = config.getDeclaringExtension();
            String extendingPluginId = extension.getNamespace();
            ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, iconName);
            element.setImageDescriptor(image);
        }
        if (element.getConfigurationElement() == null) {
            WizardsRegistryReader.logMissingAttribute(config, ATT_CLASS);
            return false;
        }
        return true;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_WIZARD)) {
            return false;
        }
        WorkbenchWizardElement wizard = this.createWizardElement(element);
        if (wizard != null) {
            this.addNewElementToResult(wizard, element);
        }
        return true;
    }

    protected void readWizards() {
        if (!this.areWizardsRead()) {
            this.createEmptyWizardCollection();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            this.readRegistry(registry, WorkbenchPlugin.PI_WORKBENCH, this.pluginPoint);
        }
    }

    protected boolean areWizardsRead() {
        return this.wizards != null;
    }

    protected Object[] getWizardCollectionElements() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizards.getChildren();
    }
}

