/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;

public abstract class UIJob
extends Job {
    private Display cachedDisplay;

    public UIJob(String name) {
        super(name);
    }

    public UIJob(Display jobDisplay, String name) {
        this(name);
        this.setDisplay(jobDisplay);
    }

    public static IStatus errorStatus(Throwable exception) {
        return StatusUtil.newStatus(4, exception.getMessage() == null ? "" : exception.getMessage(), exception);
    }

    public final IStatus run(final IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Display asyncDisplay = this.getDisplay();
        if (asyncDisplay == null || asyncDisplay.isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        asyncDisplay.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                IStatus result;
                block4: {
                    long startTime = System.currentTimeMillis();
                    result = null;
                    try {
                        long elapsed;
                        UIJob.this.setThread(Thread.currentThread());
                        result = monitor.isCanceled() ? Status.CANCEL_STATUS : UIJob.this.runInUIThread(monitor);
                        if (Policy.DEBUG_LONG_UI_WARNING && (elapsed = System.currentTimeMillis() - startTime) > 100L) {
                            WorkbenchPlugin.log(ProgressMessages.format("UIJob.longJobMessage", new Object[]{UIJob.this.getName(), String.valueOf(elapsed)}));
                        }
                        Object var7_4 = null;
                        if (result != null) break block4;
                    }
                    catch (Throwable throwable) {
                        Object var7_5 = null;
                        if (result == null) {
                            result = new Status(4, "org.eclipse.ui", 4, ProgressMessages.getString("Error"), null);
                        }
                        UIJob.this.done(result);
                        throw throwable;
                    }
                    result = new Status(4, "org.eclipse.ui", 4, ProgressMessages.getString("Error"), null);
                }
                UIJob.this.done(result);
            }
        });
        return Job.ASYNC_FINISH;
    }

    public abstract IStatus runInUIThread(IProgressMonitor var1);

    public void setDisplay(Display runDisplay) {
        Assert.isNotNull(runDisplay);
        this.cachedDisplay = runDisplay;
    }

    public Display getDisplay() {
        if (this.cachedDisplay == null && PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return this.cachedDisplay;
    }
}

