/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.osgi.framework.BundleException;

public class BundleManifest
implements IConfigurationConstants {
    private File manifestFile;
    private PluginEntry pluginEntry;
    private IOException exception;
    private String bundleURL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BundleManifest(File manifest) {
        this.manifestFile = manifest;
        if (!manifest.exists() || manifest.isDirectory()) return;
        FileInputStream fos = null;
        fos = new FileInputStream(manifest);
        this.parse(fos);
        Object var5_3 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public BundleManifest(InputStream input, String bundleUrl) {
        this.bundleURL = bundleUrl;
        if (input != null) {
            this.parse(input);
        }
    }

    private void parse(InputStream in) {
        try {
            String id;
            Manifest m = new Manifest(in);
            Attributes a = m.getMainAttributes();
            String symbolicName = a.getValue("Bundle-SymbolicName");
            if (symbolicName == null) {
                return;
            }
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
                id = elements[0].getValue();
            }
            catch (BundleException be) {
                throw new IOException(be.getMessage());
            }
            String version = a.getValue("Bundle-Version");
            if (version == null) {
                Utils.log(Messages.getString("BundleManifest.noVersion", "Bundle-Version", id));
                return;
            }
            String hostPlugin = a.getValue("Fragment-Host");
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(id, version));
            this.pluginEntry.isFragment(hostPlugin != null && hostPlugin.length() > 0);
            if (this.bundleURL != null) {
                this.pluginEntry.setURL(this.bundleURL);
            } else {
                File pluginDir = this.manifestFile.getParentFile();
                if (pluginDir != null) {
                    pluginDir = pluginDir.getParentFile();
                }
                if (pluginDir != null) {
                    this.pluginEntry.setURL("plugins/" + pluginDir.getName() + "/");
                }
            }
        }
        catch (IOException ioe) {
            this.exception = ioe;
        }
    }

    public boolean exists() {
        return this.exception != null || this.pluginEntry != null;
    }

    public PluginEntry getPluginEntry() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.pluginEntry;
    }
}

