/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ExtractTempRefactoring
extends Refactoring {
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private boolean fReplaceAllOccurrences;
    private boolean fDeclareFinal;
    private String fTempName;
    private CompilationUnit fCompilationUnitNode;
    private IExpressionFragment fSelectedExpression;
    private String[] fExcludedVariableNames;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ConstructorInvocation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SuperConstructorInvocation;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Block;

    private ExtractTempRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        Assert.isNotNull(settings);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
    }

    public static boolean isAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression(selectedNodes, coveringNode) || selectedNodes.length == 1 && selectedNodes[0] instanceof ExpressionStatement;
    }

    public static ExtractTempRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        return new ExtractTempRefactoring(cu, selectionStart, selectionLength, settings);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ExtractTempRefactoring.name");
    }

    public boolean declareFinal() {
        return this.fDeclareFinal;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.fTempName;
        }
        return proposals[0];
    }

    public String[] guessTempNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        try {
            String[] excludedVariableNames = this.getExcludedVariableNames();
            ASTNode associatedNode = this.getSelectedExpression().getAssociatedNode();
            if (associatedNode instanceof MethodInvocation) {
                proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)associatedNode, excludedVariableNames));
            }
            if (associatedNode instanceof Expression) {
                proposals.addAll(this.guessTempNamesFromExpression((Expression)associatedNode, excludedVariableNames));
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return proposals.toArray(new String[proposals.size()]);
    }

    private List guessTempNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        for (int i = 0; i < KNOWN_METHOD_NAME_PREFIXES.length; ++i) {
            String proposal;
            String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
            if (!methodName.startsWith(prefix)) continue;
            if (methodName.length() == prefix.length()) {
                return Collections.EMPTY_LIST;
            }
            char firstAfterPrefix = methodName.charAt(prefix.length());
            if (!Character.isUpperCase(firstAfterPrefix)) continue;
            methodName = proposal = Character.toLowerCase(firstAfterPrefix) + methodName.substring(prefix.length() + 1);
            break;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fCu.getJavaProject(), methodName, 0, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private List guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = selectedExpression.resolveTypeBinding();
        String typeName = ExtractTempRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fCu.getJavaProject(), typeName, expressionBinding.getDimensions(), excluded);
        return Arrays.asList(proposals);
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 2);
                this.fExcludedVariableNames = new String[bindings.length];
                for (int i = 0; i < bindings.length; ++i) {
                    this.fExcludedVariableNames[i] = bindings[i].getName();
                }
            }
            catch (JavaModelException e) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return ExtractTempRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 6);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (!this.fCu.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.syntax_error"));
                return refactoringStatus;
            }
            this.initializeAST((IProgressMonitor)new SubProgressMonitor(pm, 3));
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (!result.hasFatalError() && this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask("", 8);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.getString("ExtractTempRefactoring.select_expression");
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.isUsedInExplicitConstructorCall()) {
                RefactoringStatus message = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.explicit_constructor"));
                return message;
            }
            pm.worked(1);
            if (this.getEnclosingBodyNode() == null) {
                RefactoringStatus message = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.expr_in_method_or_initializer"));
                return message;
            }
            pm.worked(1);
            ASTNode associatedNode = selectedExpression.getAssociatedNode();
            if (associatedNode instanceof Name && associatedNode.getParent() instanceof ClassInstanceCreation && associatedNode.getLocationInParent() == ClassInstanceCreation.NAME_PROPERTY) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.name_in_new"));
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpressionBinding());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.for_initializer_updater"));
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isReferringToLocalVariableFromFor(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.refers_to_for_variable"));
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkExpressionBinding() throws JavaModelException {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("ExtractTempRefactoring.select_expression"), null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("ExtractTempRefactoring.no_void"), null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private void initializeAST(IProgressMonitor monitor) {
        this.fCompilationUnitNode = new RefactoringASTParser(2).parse(this.fCu, true, monitor);
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.null_literals"));
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.array_initializer"));
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.assignment"));
            }
            return null;
        }
        if (selectedExpression instanceof ConditionalExpression) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.single_conditional_expression"));
        }
        if (selectedExpression instanceof SimpleName) {
            if (((SimpleName)selectedExpression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.names_in_declarations"));
            }
            if (selectedExpression.getParent() instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || selectedExpression.getParent() instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.select_expression"));
            }
        }
        return null;
    }

    public RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.checkTempName(newName);
        this.checkExcludedNames(newName, status);
        return status;
    }

    private void checkExcludedNames(String newName, RefactoringStatus status) {
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(RefactoringCoreMessages.getFormattedString("ExtractTempRefactoring.another_variable", newName));
        }
    }

    public void setTempName(String newName) {
        this.fTempName = newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        block4: {
            TextBuffer buffer = null;
            try {
                buffer = TextBuffer.acquire((IFile)WorkingCopyUtil.getOriginal(this.fCu).getResource());
                pm.beginTask(RefactoringCoreMessages.getString("ExtractTempRefactoring.checking_preconditions"), 1);
                RefactoringStatus result = new RefactoringStatus();
                result.merge(this.checkMatchingFragments());
                this.checkExcludedNames(this.fTempName, result);
                DocumentChange change = new DocumentChange(RefactoringCoreMessages.getString("RenameTempRefactoring.rename"), (IDocument)new Document(this.fCu.getSource()));
                TextChangeCompatibility.addTextEdit((TextChange)change, "", this.getAllEdits(buffer));
                String newCuSource = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
                ASTParser p = ASTParser.newParser((int)2);
                p.setSource(newCuSource.toCharArray());
                p.setUnitName(this.fCu.getElementName());
                p.setProject(this.fCu.getJavaProject());
                p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)this.fCu));
                CompilationUnit newCUNode = (CompilationUnit)p.createAST(null);
                IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
                for (int i = 0; i < newProblems.length; ++i) {
                    IProblem problem = newProblems[i];
                    if (!problem.isError()) continue;
                    result.addEntry(JavaRefactorings.createStatusEntry(problem, newCuSource));
                }
                refactoringStatus = result;
                if (buffer == null) break block4;
            }
            catch (Throwable throwable) {
                if (buffer != null) {
                    TextBuffer.release(buffer);
                }
                throw throwable;
            }
            TextBuffer.release(buffer);
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkMatchingFragments() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IASTFragment[] matchingFragments = this.getMatchingFragments();
        for (int i = 0; i < matchingFragments.length; ++i) {
            ASTNode node = matchingFragments[i].getAssociatedNode();
            if (!ExtractTempRefactoring.isLeftValue(node) || ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) continue;
            String msg = RefactoringCoreMessages.getString("ExtractTempRefactoring.assigned_to");
            result.addWarning(msg, JavaStatusContext.create(this.fCu, node));
        }
        return result;
    }

    public String getTempSignaturePreview() throws JavaModelException {
        return this.getTempTypeName() + " " + this.fTempName;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (ASTNodes.getParent((ASTNode)selectedExpression, class$org$eclipse$jdt$core$dom$ConstructorInvocation == null ? (class$org$eclipse$jdt$core$dom$ConstructorInvocation = ExtractTempRefactoring.class$("org.eclipse.jdt.core.dom.ConstructorInvocation")) : class$org$eclipse$jdt$core$dom$ConstructorInvocation) != null) {
            return true;
        }
        return ASTNodes.getParent((ASTNode)selectedExpression, class$org$eclipse$jdt$core$dom$SuperConstructorInvocation == null ? (class$org$eclipse$jdt$core$dom$SuperConstructorInvocation = ExtractTempRefactoring.class$("org.eclipse.jdt.core.dom.SuperConstructorInvocation")) : class$org$eclipse$jdt$core$dom$SuperConstructorInvocation) != null;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            List initializers;
            ForStatement forStmt;
            if (parent instanceof ForStatement && ((forStmt = (ForStatement)parent).initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                List forInitializerVariables = ExtractTempRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                ForStatementChecker checker = new ForStatementChecker(forInitializerVariables);
                expression.accept((ASTVisitor)checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static List getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        Iterator iter = variableDeclarations.fragments().iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        CompilationUnitChange compilationUnitChange;
        block3: {
            TextBuffer buffer = null;
            try {
                buffer = TextBuffer.acquire((IFile)WorkingCopyUtil.getOriginal(this.fCu).getResource());
                pm.beginTask(RefactoringCoreMessages.getString("ExtractTempRefactoring.preview"), 3);
                CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.getString("ExtractTempRefactoring.extract_temp"), this.fCu);
                this.addTempDeclaration((TextChange)result);
                pm.worked(1);
                this.addImportIfNeeded((TextChange)result, buffer);
                pm.worked(1);
                this.addReplaceExpressionWithTemp((TextChange)result);
                pm.worked(1);
                compilationUnitChange = result;
                Object var6_5 = null;
                if (buffer == null) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (buffer != null) {
                    TextBuffer.release(buffer);
                }
                pm.done();
                throw throwable;
            }
            TextBuffer.release(buffer);
        }
        pm.done();
        return compilationUnitChange;
    }

    private TextEdit[] getAllEdits(TextBuffer buffer) throws CoreException {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(3);
        edits.add(this.createTempDeclarationEdit());
        TextEdit importEdit = this.createImportEditIfNeeded(buffer);
        if (importEdit != null) {
            edits.add(importEdit);
        }
        TextEdit[] replaceEdits = this.createReplaceExpressionWithTempEdits();
        for (int i = 0; i < replaceEdits.length; ++i) {
            edits.add(replaceEdits[i]);
        }
        return edits.toArray(new TextEdit[edits.size()]);
    }

    private TextEdit createTempDeclarationEdit() throws CoreException {
        if (this.shouldReplaceSelectedExpressionWithTempDeclaration()) {
            return this.replaceSelectedExpressionWithTempDeclaration();
        }
        return this.createAndInsertTempDeclaration();
    }

    private boolean shouldReplaceSelectedExpressionWithTempDeclaration() throws JavaModelException {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        return selectedFragment.getAssociatedNode().getParent() instanceof ExpressionStatement && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(selectedFragment.getAssociatedNode()));
    }

    private TextEdit createAndInsertTempDeclaration() throws CoreException {
        ASTNode insertBefore = this.getNodeToInsertTempDeclarationBefore();
        int insertOffset = insertBefore.getStartPosition();
        String text = this.createTempDeclarationSource(this.getInitializerSource(), true) + this.getIndent(insertBefore);
        return new InsertEdit(insertOffset, text);
    }

    private TextEdit replaceSelectedExpressionWithTempDeclaration() throws CoreException {
        String nodeSource = this.fCu.getBuffer().getText(this.getSelectedExpression().getStartPosition(), this.getSelectedExpression().getLength());
        String text = this.createTempDeclarationSource(nodeSource, false);
        ASTNode parent = this.getSelectedExpression().getAssociatedNode().getParent();
        Assert.isTrue(parent instanceof ExpressionStatement);
        return new ReplaceEdit(parent.getStartPosition(), parent.getLength(), text);
    }

    private TextEdit createImportEditIfNeeded(TextBuffer buffer) throws CoreException {
        ITypeBinding type = this.getSelectedExpression().getAssociatedExpression().resolveTypeBinding();
        if (type.isPrimitive()) {
            return null;
        }
        if (type.isArray() && type.getElementType().isPrimitive()) {
            return null;
        }
        ImportRewrite rewrite = new ImportRewrite(this.fCu);
        rewrite.addImport(type);
        if (rewrite.isEmpty()) {
            return null;
        }
        return rewrite.createEdit(buffer.getDocument());
    }

    private TextEdit[] createReplaceExpressionWithTempEdits() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = this.getFragmentsToReplace();
        TextEdit[] result = new TextEdit[fragmentsToReplace.length];
        for (int i = 0; i < fragmentsToReplace.length; ++i) {
            IASTFragment fragment = fragmentsToReplace[i];
            int offset = fragment.getStartPosition();
            int length = fragment.getLength();
            result[i] = new ReplaceEdit(offset, length, this.fTempName);
        }
        return result;
    }

    private void addTempDeclaration(TextChange change) throws CoreException {
        TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractTempRefactoring.declare_local_variable"), this.createTempDeclarationEdit());
    }

    private void addImportIfNeeded(TextChange change, TextBuffer buffer) throws CoreException {
        TextEdit importEdit = this.createImportEditIfNeeded(buffer);
        if (importEdit != null) {
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractTempRefactoring.update_imports"), importEdit);
        }
    }

    private void addReplaceExpressionWithTemp(TextChange change) throws JavaModelException {
        TextEdit[] edits = this.createReplaceExpressionWithTempEdits();
        for (int i = 0; i < edits.length; ++i) {
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractTempRefactoring.replace"), edits[i]);
        }
    }

    private ASTNode getNodeToInsertTempDeclarationBefore() throws JavaModelException {
        if (!this.fReplaceAllOccurrences || this.getFragmentsToReplace().length <= 1) {
            return this.getInnermostStatementInBlock(this.getSelectedExpression());
        }
        ASTNode[] firstReplaceNodeParents = ExtractTempRefactoring.getParents(this.getFirstReplacedExpression().getAssociatedNode());
        ASTNode[] commonPath = this.findDeepestCommonSuperNodePathForReplacedNodes();
        Assert.isTrue(commonPath.length <= firstReplaceNodeParents.length);
        ASTNode deepestCommonParent = firstReplaceNodeParents[commonPath.length - 1];
        if (deepestCommonParent instanceof TryStatement || deepestCommonParent instanceof IfStatement) {
            if (deepestCommonParent.getParent() instanceof Block) {
                return deepestCommonParent;
            }
            if (commonPath.length < firstReplaceNodeParents.length) {
                return this.getInnermostStatementInBlock(firstReplaceNodeParents[commonPath.length]);
            }
        }
        if (deepestCommonParent instanceof Block) {
            return firstReplaceNodeParents[commonPath.length];
        }
        return this.getInnermostStatementInBlock(this.getFirstReplacedExpression());
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes() throws JavaModelException {
        ASTNode[] matchNodes = this.getMatchNodes();
        Object[][] matchingNodesParents = new ASTNode[matchNodes.length][];
        for (int i = 0; i < matchNodes.length; ++i) {
            matchingNodesParents[i] = ExtractTempRefactoring.getParents(matchNodes[i]);
        }
        List<Object> l = Arrays.asList(ExtractTempRefactoring.getLongestArrayPrefix(matchingNodesParents));
        return l.toArray(new ASTNode[l.size()]);
    }

    private ASTNode[] getMatchNodes() throws JavaModelException {
        IASTFragment[] matches = this.getFragmentsToReplace();
        ASTNode[] result = new ASTNode[matches.length];
        for (int i = 0; i < matches.length; ++i) {
            result[i] = matches[i].getAssociatedNode();
        }
        return result;
    }

    private static Object[] getLongestArrayPrefix(Object[][] arrays) {
        int i;
        int length = -1;
        if (arrays.length == 0) {
            return new Object[0];
        }
        int minArrayLength = arrays[0].length;
        for (i = 1; i < arrays.length; ++i) {
            minArrayLength = Math.min(minArrayLength, arrays[i].length);
        }
        for (i = 0; i < minArrayLength && ExtractTempRefactoring.allArraysEqual(arrays, i); ++i) {
            ++length;
        }
        if (length == -1) {
            return new Object[0];
        }
        return ExtractTempRefactoring.getArrayPrefix(arrays[0], length + 1);
    }

    private static boolean allArraysEqual(Object[][] arrays, int position) {
        Object element = arrays[0][position];
        for (int i = 0; i < arrays.length; ++i) {
            Object[] array = arrays[i];
            if (element.equals(array[position])) continue;
            return false;
        }
        return true;
    }

    private static Object[] getArrayPrefix(Object[] array, int prefixLength) {
        Assert.isTrue(prefixLength <= array.length);
        Assert.isTrue(prefixLength >= 0);
        Object[] prefix = new Object[prefixLength];
        for (int i = 0; i < prefix.length; ++i) {
            prefix[i] = array[i];
        }
        return prefix;
    }

    private IExpressionFragment getFirstReplacedExpression() throws JavaModelException {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        IASTFragment[] nodesToReplace = this.getFragmentsToReplace();
        if (nodesToReplace.length == 0) {
            return this.getSelectedExpression();
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IASTFragment)o1).getStartPosition() - ((IASTFragment)o2).getStartPosition();
            }
        };
        Arrays.sort(nodesToReplace, comparator);
        return (IExpressionFragment)nodesToReplace[0];
    }

    private String createTempDeclarationSource(String initializerSource, boolean addTrailingLineDelimiter) throws CoreException {
        String modifier = this.fDeclareFinal ? "final " : "";
        String dummyInitializer = "0";
        String semicolon = ";";
        String dummyDeclaration = modifier + this.getTempTypeName() + " " + this.fTempName + " = " + dummyInitializer + semicolon;
        int[] position = new int[]{dummyDeclaration.length() - dummyInitializer.length() - semicolon.length()};
        String formattedDeclaration = CodeFormatterUtil.format(2, dummyDeclaration, 0, position, this.getLineDelimiter(), this.fCu.getJavaProject());
        StringBuffer formattedDummyDeclaration = new StringBuffer(formattedDeclaration);
        String tail = addTrailingLineDelimiter ? this.getLineDelimiter() : "";
        return formattedDummyDeclaration.replace(position[0], position[0] + dummyInitializer.length(), initializerSource).append(tail).toString();
    }

    private String getTempTypeName() throws JavaModelException {
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        String name = expression.resolveTypeBinding().getName();
        if (!"".equals(name) || !(expression instanceof ClassInstanceCreation)) {
            return name;
        }
        ClassInstanceCreation cic = (ClassInstanceCreation)expression;
        Assert.isTrue(cic.getAnonymousClassDeclaration() != null);
        return ASTNodes.asString((ASTNode)cic.getName());
    }

    private String getInitializerSource() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        return ExtractTempRefactoring.removeTrailingSemicolons(this.fCu.getBuffer().getText(fragment.getStartPosition(), fragment.getLength()));
    }

    private static String removeTrailingSemicolons(String s) {
        String arg = s.trim();
        if (!arg.endsWith(";")) {
            return arg;
        }
        return ExtractTempRefactoring.removeTrailingSemicolons(arg.substring(0, arg.length() - 1));
    }

    private String getIndent(ASTNode insertBefore) throws CoreException {
        return CodeFormatterUtil.createIndentString(CodeRefactoringUtil.getIndentationLevel(insertBefore, this.getFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLineDelimiter() throws CoreException {
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(this.getFile());
            String string = buffer.getLineDelimiter(buffer.getLineOfOffset(this.fSelectionStart));
            return string;
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }

    private Statement getInnermostStatementInBlock(IASTFragment fragment) {
        return this.getInnermostStatementInBlock(fragment.getAssociatedNode());
    }

    private Statement getInnermostStatementInBlock(ASTNode node) {
        Block block = (Block)ASTNodes.getParent(node, class$org$eclipse$jdt$core$dom$Block == null ? (class$org$eclipse$jdt$core$dom$Block = ExtractTempRefactoring.class$("org.eclipse.jdt.core.dom.Block")) : class$org$eclipse$jdt$core$dom$Block);
        if (block == null) {
            return null;
        }
        Iterator iter = block.statements().iterator();
        while (iter.hasNext()) {
            Statement statement = (Statement)iter.next();
            if (!ASTNodes.isParent(node, (ASTNode)statement)) continue;
            return statement;
        }
        return null;
    }

    private IASTFragment[] getFragmentsToReplace() throws JavaModelException {
        return ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        if (this.fReplaceAllOccurrences) {
            IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)this.getEnclosingBodyNode()).getSubFragmentsMatching(this.getSelectedExpression());
            return allMatches;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        for (int i = 0; i < allMatches.length; ++i) {
            if (!ExtractTempRefactoring.canReplace(allMatches[i])) continue;
            result.add(allMatches[i]);
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (ExtractTempRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (ExtractTempRefactoring.isLeftValue(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        return !ExtractTempRefactoring.isUsedInForInitializerOrUpdater((Expression)node);
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration;
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private Block getEnclosingBodyNode() throws JavaModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        do {
            switch (node.getNodeType()) {
                case 31: {
                    return ((MethodDeclaration)node).getBody();
                }
                case 28: {
                    return ((Initializer)node).getBody();
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private static ASTNode[] getParents(ASTNode node) {
        ASTNode current = node;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>();
        do {
            parents.add(current.getParent());
        } while ((current = current.getParent()).getParent() != null);
        Collections.reverse(parents);
        return parents.toArray(new ASTNode[parents.size()]);
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null && selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
            ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
            Expression expression = exprStatement.getExpression();
            this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
        }
        return this.fSelectedExpression;
    }

    private IFile getFile() {
        return ResourceUtil.getFile(this.fCu);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection forInitializerVariables) {
            Assert.isNotNull(forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }
}

