/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.bundle.Bundle;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;

public abstract class BundleModel
extends AbstractModel
implements IBundleModel {
    private Bundle fBundle = new Bundle();

    public BundleModel() {
        this.fBundle.setModel(this);
    }

    public IBundle getBundle() {
        if (!this.isLoaded()) {
            this.load();
        }
        return this.fBundle;
    }

    public String getInstallLocation() {
        return null;
    }

    public abstract void load();

    public boolean isFragmentModel() {
        return this.fBundle.getHeader("Fragment-Host") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream source, boolean outOfSync) {
        try {
            Manifest m = new Manifest(source);
            this.fBundle.load(this.manifestToProperties(m.getMainAttributes()));
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (IOException iOException) {}
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public void reload(InputStream source, boolean outOfSync) {
        this.load(source, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[0], null));
    }

    public boolean isReconcilingModel() {
        return false;
    }
}

