/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IStatusListener;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class StatusListener
extends CommandOutputListener {
    private static boolean isFolder = false;
    private IStatusListener statusListener;

    public StatusListener(IStatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (line.startsWith("   Repository revision:") && !line.startsWith("   Repository revision:\tNo revision control file")) {
            int separatingTabIndex = line.indexOf(9, 24);
            String remoteRevision = line.substring(24, separatingTabIndex);
            String fileLocation = line.substring(separatingTabIndex + 1, line.length() - 2);
            this.statusListener.fileStatus(commandRoot, this.removeAtticSegment(fileLocation), remoteRevision);
        }
        return ICommandOutputListener.OK;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        String serverMessage = this.getServerMessage(line, location);
        if (serverMessage != null) {
            if (serverMessage.startsWith("conflict:")) {
                return new CVSStatus(2, -12, commandRoot, line);
            }
            if (serverMessage.startsWith("Examining")) {
                isFolder = true;
                return ICommandOutputListener.OK;
            }
        }
        if (isFolder) {
            isFolder = false;
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }

    private String removeAtticSegment(String path) {
        return Util.removeAtticSegment(path);
    }
}

