/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.UpdateSearchRequest;

public class FindUpdatesAction
extends Action {
    private IFeature feature;
    private Shell shell;

    public FindUpdatesAction(Shell shell, String text) {
        super(text);
        this.shell = shell;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public void run() {
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
            return;
        }
        if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUI.getString("Actions.brokenConfigQuestion"))) {
            return;
        }
        IFeature[] features = null;
        if (this.feature != null) {
            features = new IFeature[]{this.feature};
        }
        final UpdateSearchRequest searchRequest = UpdateUtils.createNewUpdatesRequest(features);
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                InstallWizard wizard = new InstallWizard(searchRequest);
                ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(FindUpdatesAction.this.shell, (IWizard)wizard, UpdateUI.getString("FindUpdatesAction.updates"));
                dialog.create();
                dialog.open();
            }
        });
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("FeatureStateAction.dialogTitle"), (String)message);
    }
}

