/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ToolbarButton
extends JButton
implements MouseListener {
    ImageIcon normal;
    ImageIcon over;
    ImageIcon down;
    boolean hover = false;
    boolean mac = System.getProperty("os.name").indexOf("Mac") != -1;

    public ToolbarButton(Image image) {
        try {
            this.normal = new ImageIcon(image);
            BufferedImage bufferedImage = new BufferedImage(this.normal.getIconWidth(), this.normal.getIconHeight(), 2);
            bufferedImage.getGraphics().drawImage(this.normal.getImage(), 0, 0, this);
            if (!this.mac) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(this), bufferedImage.getHeight(this), 2);
                for (int i = 0; i < bufferedImage.getWidth(this); ++i) {
                    for (n5 = 0; n5 < bufferedImage.getHeight(this); ++n5) {
                        Graphics graphics = bufferedImage2.getGraphics();
                        int n6 = bufferedImage.getRGB(i, n5);
                        n4 = n6 >> 16 & 0xFF;
                        n3 = n6 >> 8 & 0xFF;
                        n2 = n6 & 0xFF;
                        n = n6 >> 24 & 0xFF;
                        graphics.setColor(this.brighter(new Color(n4, n3, n2, n), 0.92));
                        graphics.fillRect(i, n5, 1, 1);
                    }
                }
                this.over = new ImageIcon(bufferedImage2);
                BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(this), bufferedImage.getHeight(this), 2);
                for (n5 = 0; n5 < bufferedImage.getWidth(this); ++n5) {
                    for (int i = 0; i < bufferedImage.getHeight(this); ++i) {
                        Graphics graphics = bufferedImage3.getGraphics();
                        n4 = bufferedImage.getRGB(n5, i);
                        n3 = n4 >> 16 & 0xFF;
                        n2 = n4 >> 8 & 0xFF;
                        n = n4 & 0xFF;
                        int n7 = n4 >> 24 & 0xFF;
                        graphics.setColor(this.darker(new Color(n3, n2, n, n7), 0.92));
                        graphics.fillRect(n5, i, 1, 1);
                    }
                }
                this.down = new ImageIcon(bufferedImage3);
            }
            this.setIcon(this.normal);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(this.normal.getIconWidth() + 8, this.normal.getIconHeight() + 8));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setText("  ");
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mac) {
            return;
        }
        this.setIcon(this.down);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mac) {
            return;
        }
        if (this.hover) {
            this.setIcon(this.over);
        } else {
            this.setIcon(this.normal);
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mac) {
            return;
        }
        this.hover = true;
        this.setIcon(this.over);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mac) {
            return;
        }
        this.hover = false;
        this.setIcon(this.normal);
        this.repaint();
    }

    public Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n5, n5, n5, n4);
        }
        if (n > 0 && n < n5) {
            n = n5;
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255), n4);
    }

    public Color darker(Color color, double d) {
        return new Color(Math.max((int)((double)color.getRed() * d), 0), Math.max((int)((double)color.getGreen() * d), 0), Math.max((int)((double)color.getBlue() * d), 0), color.getAlpha());
    }
}

