/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common.orders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.videolan.vlma.common.Configuration;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.adapters.IVlAdapter;
import org.videolan.vlma.common.medias.VlFilesChannel;
import org.videolan.vlma.common.medias.VlMediaGroup;
import org.videolan.vlma.common.medias.VlSatChannel;
import org.videolan.vlma.common.medias.VlTNTChannel;

public class VlOrder {
    private static final Logger logger = Logger.getLogger(VlOrder.class);
    private VlServer server;
    private IVlAdapter adapter;
    private VlMediaGroup medias;
    private static final int TELNET_DEFAULT_WAIT = 100;
    private static final int TELNET_DEFAULT_DELAY = 1000;
    private static final int VLC_TTL = 12;
    private static final int VLC_DVB_BANDWIDTH = 8;
    private Socket telnetSocket;
    private PrintWriter telnetOut;
    private BufferedReader telnetIn;

    public IVlAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(IVlAdapter adapter) {
        this.adapter = adapter;
    }

    public VlServer getServer() {
        return this.server;
    }

    public void setServer(VlServer server) {
        this.server = server;
    }

    public VlMediaGroup getMedias() {
        return this.medias;
    }

    public void setMedias(VlMediaGroup medias) {
        this.medias = medias;
    }

    private String getVLMCommandName() {
        return "flux-" + this.adapter.getName();
    }

    private void telnetConnect() throws IOException {
        this.telnetSocket = new Socket(this.server.getIp(), Configuration.getInstance().getVlcTelnetPort());
        this.telnetOut = new PrintWriter(this.telnetSocket.getOutputStream(), true);
        this.telnetIn = new BufferedReader(new InputStreamReader(this.telnetSocket.getInputStream()));
        this.telnetOut.println(Configuration.getInstance().getVlcTelnetPassword());
    }

    private void telnetClose() throws IOException {
        this.telnetOut.close();
        this.telnetIn.close();
        this.telnetSocket.close();
    }

    private void telnetCommand(String command) throws IOException {
        logger.log(Level.DEBUG, "Envoi de la commande " + command + " \u00e0 " + this.server.getName());
        this.telnetOut.println(command);
        int d = 1000;
        while (!this.telnetIn.ready() && (d -= 100) > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        String r = "";
        while (this.telnetIn.ready()) {
            r = r + (char)this.telnetIn.read();
        }
        logger.log(Level.DEBUG, "Command result: " + r);
    }

    public void start() throws IOException {
        this.telnetConnect();
        this.telnetCommand("setup " + this.getVLMCommandName() + " disabled");
        this.telnetCommand("control " + this.getVLMCommandName() + " stop");
        this.telnetCommand("del " + this.getVLMCommandName());
        this.telnetCommand("new " + this.getVLMCommandName() + " broadcast");
        this.telnetCommand("setup " + this.getVLMCommandName() + " option vvv");
        this.telnetCommand("setup " + this.getVLMCommandName() + " option color");
        this.telnetCommand("setup " + this.getVLMCommandName() + " option ttl=" + Integer.toString(12));
        if (this.medias.getMediaClass() == VlSatChannel.class) {
            if (!this.medias.medias.isEmpty()) {
                VlSatChannel vlSatChannel = (VlSatChannel)this.medias.medias.get(0);
                this.telnetCommand("setup " + this.getVLMCommandName() + " input dvb://");
                this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-frequency=" + Integer.toString(vlSatChannel.getFrequency() * 1000));
                this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-adapter=" + this.getAdapter().getName());
                this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-bandwidth=" + Integer.toString(8));
                if (vlSatChannel.getPolarisation() == 'H') {
                    this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-voltage=18");
                } else if (vlSatChannel.getPolarisation() == 'V') {
                    this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-voltage=13");
                }
                this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-srate=" + vlSatChannel.getSymbolRate());
                String ids = "";
                String command = "";
                for (VlSatChannel vlSatChannel2 : this.medias.medias) {
                    if (ids != "") {
                        ids = ids + ",";
                    }
                    ids = ids + Integer.toString(vlSatChannel2.getSid());
                    if (command != "") {
                        command = command + ",";
                    }
                    command = command + String.format("dst=standard{mux=ts,access=udp,dst=%s,sap,name=\"%s\",group=\"%s\"},select=\"program=%d\"", vlSatChannel2.getProgram().getIp().getHostAddress(), vlSatChannel2.getProgram().getSapName(), vlSatChannel2.getProgram().getSapGroup(), vlSatChannel2.getSid());
                }
                this.telnetCommand("setup " + this.getVLMCommandName() + " option programs=" + ids);
                command = "setup " + this.getVLMCommandName() + " output #duplicate{" + command + "}";
                this.telnetCommand(command);
                this.telnetCommand("setup " + this.getVLMCommandName() + " enabled");
                this.telnetCommand("control " + this.getVLMCommandName() + " play");
            }
        } else if (this.medias.getMediaClass() == VlTNTChannel.class) {
            if (!this.medias.medias.isEmpty()) {
                VlTNTChannel vlTNTChannel = (VlTNTChannel)this.medias.medias.get(0);
                this.telnetCommand("setup " + this.getVLMCommandName() + " input dvb://");
                this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-frequency=" + Integer.toString(vlTNTChannel.getFrequency()));
                this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-adapter=" + this.getAdapter().getName());
                this.telnetCommand("setup " + this.getVLMCommandName() + " option dvb-bandwidth=" + Integer.toString(8));
                String ids = "";
                String command = "";
                for (VlTNTChannel vlTNTChannel2 : this.medias.medias) {
                    if (ids != "") {
                        ids = ids + ",";
                    }
                    ids = ids + Integer.toString(vlTNTChannel2.getSid());
                    if (command != "") {
                        command = command + ",";
                    }
                    command = command + String.format("dst=standard{mux=ts,access=udp,dst=%s,sap,name=\"%s\",group=\"%s\"},select=\"program=%d\"", vlTNTChannel2.getProgram().getIp().getHostAddress(), vlTNTChannel2.getProgram().getSapName(), vlTNTChannel2.getProgram().getSapGroup(), vlTNTChannel2.getSid());
                }
                this.telnetCommand("setup " + this.getVLMCommandName() + " option programs=" + ids);
                command = "setup " + this.getVLMCommandName() + " output #duplicate{" + command + "}";
                this.telnetCommand(command);
                this.telnetCommand("setup " + this.getVLMCommandName() + " enabled");
                this.telnetCommand("control " + this.getVLMCommandName() + " play");
            }
        } else if (this.medias.getMediaClass() == VlFilesChannel.class && !this.medias.medias.isEmpty()) {
            VlFilesChannel vlFilesChannel = (VlFilesChannel)this.medias.medias.get(0);
            this.telnetCommand("setup " + this.getVLMCommandName() + " loop");
            this.telnetCommand("setup " + this.getVLMCommandName() + " option sout-keep");
            for (String file_path : vlFilesChannel.getFiles()) {
                this.telnetCommand("setup " + this.getVLMCommandName() + " input \"" + file_path + "\"");
            }
            String command = String.format("#standard{mux=ts,access=udp,dst=%s,sap,name=\"%s\",group=\"%s\"}", vlFilesChannel.getProgram().getIp().getHostAddress(), vlFilesChannel.getProgram().getSapName(), vlFilesChannel.getProgram().getSapGroup());
            command = "setup " + this.getVLMCommandName() + " output " + command;
            this.telnetCommand(command);
            this.telnetCommand("setup " + this.getVLMCommandName() + " enabled");
            this.telnetCommand("control " + this.getVLMCommandName() + " play");
        }
        this.telnetClose();
    }

    public void stop() throws IOException {
        this.telnetConnect();
        this.telnetCommand("control " + this.getVLMCommandName() + " disabled");
        this.telnetCommand("control " + this.getVLMCommandName() + " stop");
        this.telnetCommand("del " + this.getVLMCommandName());
        this.telnetClose();
    }
}

