/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.files;

import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.VlFilesChannel;
import org.videolan.vlma.web.files.FilesChannelsAdd;

public class FilesChannelsAddValidator
implements Validator {
    public boolean supports(Class arg0) {
        return arg0.equals(FilesChannelsAdd.class);
    }

    public void validate(Object arg0, Errors arg1) {
        FilesChannelsAdd filesChannelsAdd = (FilesChannelsAdd)arg0;
        if ("".equals(filesChannelsAdd.getName())) {
            arg1.rejectValue("name", "medias.fileschannel.add.error.name_not_specified");
            return;
        }
        if ("".equals(filesChannelsAdd.getFiles())) {
            arg1.rejectValue("files", "medias.fileschannel.add.error.files_not_specified");
            return;
        }
        IVlData data = filesChannelsAdd.getData();
        List medias = data.getMedias();
        if (medias != null) {
            VlFilesChannel filesChannel = new VlFilesChannel();
            filesChannel.setName(filesChannelsAdd.getName());
            if (medias.contains(filesChannel)) {
                arg1.rejectValue("name", "medias.fileschannel.add.error.existing_name");
                return;
            }
        }
    }
}

