/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.medias;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.videolan.vlma.web.medias.MediasProgramAdd;

public class MediasProgramAddValidator
implements Validator {
    public boolean supports(Class arg0) {
        return arg0.equals(MediasProgramAdd.class);
    }

    public void validate(Object arg0, Errors arg1) {
        MediasProgramAdd mediasProgramAdd = (MediasProgramAdd)arg0;
        if (mediasProgramAdd == null) {
            arg1.rejectValue("sap", "medias.program.add.error.not-specified");
            return;
        }
        if (mediasProgramAdd.getData().getMedia(mediasProgramAdd.getMediaId()) == null) {
            arg1.rejectValue("sap", "medias.program.add.error.nonexisting");
            return;
        }
        if ("".equals(mediasProgramAdd.getSap())) {
            arg1.rejectValue("sap", "medias.program.add.error.invalidsap");
        }
        try {
            int p = Integer.parseInt(mediasProgramAdd.getPriority());
            if (p < 1) {
                arg1.rejectValue("priority", "medias.program.add.error.invalidpriority");
            }
        }
        catch (NumberFormatException e) {
            arg1.rejectValue("priority", "medias.program.add.error.invalidpriority");
        }
    }
}

