/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.servers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.web.servers.ServersAdd;

public class ServersAddValidator
implements Validator {
    public boolean supports(Class arg0) {
        return arg0.equals(ServersAdd.class);
    }

    public void validate(Object arg0, Errors arg1) {
        InetAddress serverAddress;
        ServersAdd serversAdd = (ServersAdd)arg0;
        if (serversAdd == null) {
            arg1.rejectValue("name", "servers.add.error.not-specified");
            return;
        }
        if ("".equals(serversAdd.getName())) {
            arg1.rejectValue("name", "servers.add.error.invalidname");
            return;
        }
        if ("".equals(serversAdd.getAddress())) {
            arg1.rejectValue("address", "servers.add.error.invalidaddress");
            return;
        }
        try {
            serverAddress = InetAddress.getByName(serversAdd.getAddress());
        }
        catch (UnknownHostException e) {
            arg1.rejectValue("address", "servers.add.error.invalidaddress");
            return;
        }
        IVlData data = serversAdd.getData();
        List servers = data.getServers();
        if (servers != null) {
            for (VlServer server : servers) {
                if (server.getName() == serversAdd.getName()) {
                    arg1.rejectValue("name", "servers.add.error.existingname");
                    return;
                }
                if (!serverAddress.equals(server.getIp())) continue;
                arg1.rejectValue("address", "servers.add.error.existingaddress");
                return;
            }
        }
    }
}

