/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.welcome;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.videolan.vlma.Data;
import org.videolan.vlma.model.FilesChannel;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.SatChannel;
import org.videolan.vlma.model.StreamChannel;
import org.videolan.vlma.model.DTTChannel;

public class WelcomeController implements Controller {

    public ModelAndView handleRequest(HttpServletRequest arg0,
            HttpServletResponse arg1) throws Exception {
        List<SatChannel> satChannels = new ArrayList<SatChannel>();
        List<DTTChannel> dttChannels = new ArrayList<DTTChannel>();
        List<FilesChannel> fileChannels = new ArrayList<FilesChannel>();
        List<StreamChannel> streamChannels = new ArrayList<StreamChannel>();
        for (Media media : data.getMedias())
            if (media.getProgram() != null)
                if (media.getClass().equals(SatChannel.class)) {
                    SatChannel channel = (SatChannel) media;
                    satChannels.add(channel);
                } else if (media.getClass().equals(DTTChannel.class)) {
                    DTTChannel channel = (DTTChannel) media;
                    dttChannels.add(channel);
                } else if (media.getClass().equals(FilesChannel.class)) {
                    FilesChannel channel = (FilesChannel) media;
                    fileChannels.add(channel);
                } else if (media.getClass().equals(StreamChannel.class)) {
                    StreamChannel channel = (StreamChannel) media;
                    streamChannels.add(channel);
                }
        ModelAndView mav = new ModelAndView();
        mav.addObject("satChannels", satChannels);
        mav.addObject("dttChannels", dttChannels);
        mav.addObject("fileChannels", fileChannels);
        mav.addObject("streamChannels", streamChannels);
        mav.addObject("servers", data.getServers());
        return mav;
    }

    private Data data;

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

}
